/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.categories;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.dries007.tfc.compat.jei.BaseRecipeCategory;
import net.dries007.tfc.compat.jei.wrappers.SimpleRecipeWrapper;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class QuernCategory
extends BaseRecipeCategory<SimpleRecipeWrapper> {
    private static final ResourceLocation ICONS = new ResourceLocation("tfc", "textures/gui/icons/jei.png");
    private final IDrawableStatic slot;
    private final IDrawableStatic arrow;
    private final IDrawableAnimated arrowAnimated;

    public QuernCategory(IGuiHelper helper, String Uid) {
        super((IDrawable)helper.createBlankDrawable(120, 38), Uid);
        this.arrow = helper.createDrawable(ICONS, 0, 14, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(ICONS, 22, 14, 22, 16);
        this.arrowAnimated = helper.createAnimatedDrawable(arrowAnimated, 80, IDrawableAnimated.StartDirection.LEFT, false);
        this.slot = helper.getSlotDrawable();
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 50, 16);
        this.arrowAnimated.draw(minecraft, 50, 16);
        this.slot.draw(minecraft, 0, 16);
        this.slot.draw(minecraft, 20, 16);
        this.slot.draw(minecraft, 84, 16);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SimpleRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.init(0, true, 0, 16);
        itemStackGroup.init(1, true, 20, 16);
        itemStackGroup.init(2, false, 84, 16);
        itemStackGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStackGroup.set(1, new ItemStack(ItemsTFC.HANDSTONE));
        itemStackGroup.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

