/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipeFoodPreservation;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipeFoodTraits;
import net.dries007.tfc.api.recipes.heat.HeatRecipeMetalMelting;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.client.gui.GuiAnvilTFC;
import net.dries007.tfc.client.gui.GuiBarrel;
import net.dries007.tfc.client.gui.GuiCalendar;
import net.dries007.tfc.client.gui.GuiCrucible;
import net.dries007.tfc.client.gui.GuiFirePit;
import net.dries007.tfc.client.gui.GuiKnapping;
import net.dries007.tfc.client.gui.GuiNutrition;
import net.dries007.tfc.client.gui.GuiSkills;
import net.dries007.tfc.compat.jei.TFCInventoryGuiHandler;
import net.dries007.tfc.compat.jei.categories.AlloyCategory;
import net.dries007.tfc.compat.jei.categories.AnvilCategory;
import net.dries007.tfc.compat.jei.categories.BarrelCategory;
import net.dries007.tfc.compat.jei.categories.BlastFurnaceCategory;
import net.dries007.tfc.compat.jei.categories.BloomeryCategory;
import net.dries007.tfc.compat.jei.categories.CastingCategory;
import net.dries007.tfc.compat.jei.categories.ChiselCategory;
import net.dries007.tfc.compat.jei.categories.HeatCategory;
import net.dries007.tfc.compat.jei.categories.KnappingCategory;
import net.dries007.tfc.compat.jei.categories.LoomCategory;
import net.dries007.tfc.compat.jei.categories.MetalHeatingCategory;
import net.dries007.tfc.compat.jei.categories.QuernCategory;
import net.dries007.tfc.compat.jei.categories.RockLayerCategory;
import net.dries007.tfc.compat.jei.categories.VeinCategory;
import net.dries007.tfc.compat.jei.categories.WeldingCategory;
import net.dries007.tfc.compat.jei.wrappers.AlloyRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.AnvilRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.BarrelRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.BlastFurnaceRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.BloomeryRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.CastingRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.ChiselRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.HeatRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.KnappingRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.MetalHeatingRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.RockLayerWrapper;
import net.dries007.tfc.compat.jei.wrappers.SaltingRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.SimpleRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.UnmoldRecipeWrapper;
import net.dries007.tfc.compat.jei.wrappers.VeinWrapper;
import net.dries007.tfc.compat.jei.wrappers.WeldingRecipeWrapper;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLoom;
import net.dries007.tfc.objects.container.ContainerInventoryCrafting;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.items.metal.ItemAnvil;
import net.dries007.tfc.objects.items.metal.ItemMetalChisel;
import net.dries007.tfc.objects.items.metal.ItemMetalTool;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.objects.recipes.SaltingRecipe;
import net.dries007.tfc.world.classic.worldgen.vein.VeinRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@JEIPlugin
public final class TFCJEIPlugin
implements IModPlugin {
    public static final String ALLOY_UID = "tfc.alloy";
    public static final String ANVIL_UID = "tfc.anvil";
    public static final String BARREL_UID = "tfc.barrel";
    public static final String BLAST_FURNACE_UID = "tfc.blast_furnace";
    public static final String BLOOMERY_UID = "tfc.bloomery";
    public static final String CASTING_UID = "tfc.casting";
    public static final String CHISEL_UID = "tfc.chisel";
    public static final String HEAT_UID = "tfc.heat";
    public static final String KNAP_CLAY_UID = "tfc.knap.clay";
    public static final String KNAP_FIRECLAY_UID = "tfc.knap.fireclay";
    public static final String KNAP_LEATHER_UID = "tfc.knap.leather";
    public static final String KNAP_STONE_UID = "tfc.knap.stone";
    public static final String METAL_HEAT_UID = "tfc.metal_heat";
    public static final String LOOM_UID = "tfc.loom";
    public static final String QUERN_UID = "tfc.quern";
    public static final String ROCK_LAYER_UID = "tfc.rock_layer";
    public static final String VEIN_UID = "tfc.vein";
    public static final String WELDING_UID = "tfc.welding";
    private static IModRegistry REGISTRY;

    public static Collection<ItemStack> getAllIngredients() {
        return REGISTRY.getIngredientRegistry().getAllIngredients(VanillaTypes.ITEM);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyCategory(registry.getJeiHelpers().getGuiHelper(), ALLOY_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AnvilCategory(registry.getJeiHelpers().getGuiHelper(), ANVIL_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BarrelCategory(registry.getJeiHelpers().getGuiHelper(), BARREL_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BlastFurnaceCategory(registry.getJeiHelpers().getGuiHelper(), BLAST_FURNACE_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BloomeryCategory(registry.getJeiHelpers().getGuiHelper(), BLOOMERY_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingCategory(registry.getJeiHelpers().getGuiHelper(), CASTING_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChiselCategory(registry.getJeiHelpers().getGuiHelper(), CHISEL_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new HeatCategory(registry.getJeiHelpers().getGuiHelper(), HEAT_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new KnappingCategory(registry.getJeiHelpers().getGuiHelper(), KNAP_CLAY_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new KnappingCategory(registry.getJeiHelpers().getGuiHelper(), KNAP_FIRECLAY_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new KnappingCategory(registry.getJeiHelpers().getGuiHelper(), KNAP_LEATHER_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new KnappingCategory(registry.getJeiHelpers().getGuiHelper(), KNAP_STONE_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new LoomCategory(registry.getJeiHelpers().getGuiHelper(), LOOM_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MetalHeatingCategory(registry.getJeiHelpers().getGuiHelper(), METAL_HEAT_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new QuernCategory(registry.getJeiHelpers().getGuiHelper(), QUERN_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RockLayerCategory(registry.getJeiHelpers().getGuiHelper(), ROCK_LAYER_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VeinCategory(registry.getJeiHelpers().getGuiHelper(), VEIN_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new WeldingCategory(registry.getJeiHelpers().getGuiHelper(), WELDING_UID)});
    }

    public void register(IModRegistry registry) {
        REGISTRY = registry;
        List quernList = TFCRegistries.QUERN.getValuesCollection().stream().map(SimpleRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(quernList, QUERN_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.QUERN), new String[]{QUERN_UID});
        List heatList = TFCRegistries.HEAT.getValuesCollection().stream().filter(r -> r.getOutputs().size() > 0 && r.getIngredients().size() > 0).map(HeatRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(heatList, HEAT_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.FIREPIT), new String[]{HEAT_UID});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.CHARCOAL_FORGE), new String[]{HEAT_UID});
        List anvilList = TFCRegistries.ANVIL.getValuesCollection().stream().map(AnvilRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(anvilList, ANVIL_UID);
        List weldList = TFCRegistries.WELDING.getValuesCollection().stream().map(WeldingRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(weldList, WELDING_UID);
        List loomRecipes = TFCRegistries.LOOM.getValuesCollection().stream().map(SimpleRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(loomRecipes, LOOM_UID);
        for (Tree tree : TFCRegistries.TREES.getValuesCollection()) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockLoom.get(tree)), new String[]{LOOM_UID});
        }
        List alloyRecipes = TFCRegistries.ALLOYS.getValuesCollection().stream().map(AlloyRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(alloyRecipes, ALLOY_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.CRUCIBLE), new String[]{ALLOY_UID});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ItemsTFC.FIRED_VESSEL), new String[]{ALLOY_UID});
        List clayknapRecipes = TFCRegistries.KNAPPING.getValuesCollection().stream().filter(recipe -> recipe.getType() == KnappingType.CLAY).map(recipe -> new KnappingRecipeWrapper((KnappingRecipe)((Object)recipe), registry.getJeiHelpers().getGuiHelper())).collect(Collectors.toList());
        registry.addRecipes(clayknapRecipes, KNAP_CLAY_UID);
        for (Object stack2 : OreDictionary.getOres((String)"clay")) {
            registry.addRecipeCatalyst(stack2, new String[]{KNAP_CLAY_UID});
        }
        List fireclayknapRecipes = TFCRegistries.KNAPPING.getValuesCollection().stream().filter(recipe -> recipe.getType() == KnappingType.FIRE_CLAY).map(recipe -> new KnappingRecipeWrapper((KnappingRecipe)((Object)recipe), registry.getJeiHelpers().getGuiHelper())).collect(Collectors.toList());
        registry.addRecipes(fireclayknapRecipes, KNAP_FIRECLAY_UID);
        for (Object stack3 : OreDictionary.getOres((String)"fireClay")) {
            registry.addRecipeCatalyst(stack3, new String[]{KNAP_FIRECLAY_UID});
        }
        List leatherknapRecipes = TFCRegistries.KNAPPING.getValuesCollection().stream().filter(recipe -> recipe.getType() == KnappingType.LEATHER).map(recipe -> new KnappingRecipeWrapper((KnappingRecipe)((Object)recipe), registry.getJeiHelpers().getGuiHelper())).collect(Collectors.toList());
        registry.addRecipes(leatherknapRecipes, KNAP_LEATHER_UID);
        for (Object stack4 : OreDictionary.getOres((String)"leather")) {
            registry.addRecipeCatalyst(stack4, new String[]{KNAP_LEATHER_UID});
        }
        List stoneknapRecipes = TFCRegistries.KNAPPING.getValuesCollection().stream().filter(recipe -> recipe.getType() == KnappingType.STONE).flatMap(recipe -> TFCRegistries.ROCKS.getValuesCollection().stream().map(rock -> new KnappingRecipeWrapper.Stone((KnappingRecipe)((Object)recipe), registry.getJeiHelpers().getGuiHelper(), (Rock)((Object)((Object)rock))))).collect(Collectors.toList());
        registry.addRecipes(stoneknapRecipes, KNAP_STONE_UID);
        for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
            registry.addRecipeCatalyst((Object)new ItemStack((Item)ItemRock.get(rock)), new String[]{KNAP_STONE_UID});
        }
        List barrelRecipes = TFCRegistries.BARREL.getValuesCollection().stream().filter(recipe -> recipe instanceof BarrelRecipeFoodTraits || recipe instanceof BarrelRecipeFoodPreservation || recipe.getOutputStack() != ItemStack.field_190927_a || recipe.getOutputFluid() != null).map(BarrelRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(barrelRecipes, BARREL_UID);
        for (Item barrelItem : BlocksTFC.getAllBarrelItemBlocks()) {
            registry.addRecipeCatalyst((Object)new ItemStack(barrelItem), new String[]{BARREL_UID});
        }
        List bloomeryList = TFCRegistries.BLOOMERY.getValuesCollection().stream().map(BloomeryRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(bloomeryList, BLOOMERY_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.BLOOMERY), new String[]{BLOOMERY_UID});
        List blastList = TFCRegistries.BLAST_FURNACE.getValuesCollection().stream().map(BlastFurnaceRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(blastList, BLAST_FURNACE_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.BLAST_FURNACE), new String[]{BLAST_FURNACE_UID});
        ArrayList heatMetalList = new ArrayList();
        TFCJEIPlugin.getAllIngredients().forEach(stack -> {
            FluidStack fluidStack;
            HeatRecipeMetalMelting recipe = TFCRegistries.HEAT.getValuesCollection().stream().filter(x -> x instanceof HeatRecipeMetalMelting).filter(x -> x.isValidInput((ItemStack)stack, Metal.Tier.TIER_VI)).findFirst().orElse(null);
            if (recipe != null && (fluidStack = recipe.getOutputFluid((ItemStack)stack)) != null && FluidsTFC.getMetalFromFluid(fluidStack.getFluid()) == recipe.getMetal()) {
                MetalHeatingRecipeWrapper wrapper = new MetalHeatingRecipeWrapper((ItemStack)stack, recipe.getMetal(), fluidStack.amount, recipe.getTransformTemp());
                heatMetalList.add(wrapper);
            }
        });
        registry.addRecipes(heatMetalList, METAL_HEAT_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.CRUCIBLE), new String[]{METAL_HEAT_UID});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ItemsTFC.FIRED_VESSEL), new String[]{METAL_HEAT_UID});
        List chiselList = TFCRegistries.CHISEL.getValuesCollection().stream().map(ChiselRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(chiselList, CHISEL_UID);
        List rockLayerList = TFCRegistries.ROCKS.getValuesCollection().stream().map(RockLayerWrapper::new).collect(Collectors.toList());
        registry.addRecipes(rockLayerList, ROCK_LAYER_UID);
        List veinList = VeinRegistry.INSTANCE.getVeins().values().stream().map(VeinWrapper::new).collect(Collectors.toList());
        registry.addRecipes(veinList, VEIN_UID);
        ArrayList<UnmoldRecipeWrapper> unmoldList = new ArrayList<UnmoldRecipeWrapper>();
        ArrayList<CastingRecipeWrapper> castingList = new ArrayList<CastingRecipeWrapper>();
        List tierOrdered = TFCRegistries.METALS.getValuesCollection().stream().sorted(Comparator.comparingInt(metal -> metal.getTier().ordinal())).collect(Collectors.toList());
        for (Metal metal2 : tierOrdered) {
            if (Metal.ItemType.ANVIL.hasType(metal2)) {
                registry.addRecipeCatalyst((Object)new ItemStack(ItemAnvil.get(metal2, Metal.ItemType.ANVIL)), new String[]{ANVIL_UID});
                registry.addRecipeCatalyst((Object)new ItemStack(ItemAnvil.get(metal2, Metal.ItemType.ANVIL)), new String[]{WELDING_UID});
            }
            if (Metal.ItemType.CHISEL.hasType(metal2)) {
                registry.addRecipeCatalyst((Object)new ItemStack(ItemMetalChisel.get(metal2, Metal.ItemType.CHISEL)), new String[]{CHISEL_UID});
            }
            if (Metal.ItemType.PROPICK.hasType(metal2)) {
                registry.addRecipeCatalyst((Object)new ItemStack(ItemMetalTool.get(metal2, Metal.ItemType.PROPICK)), new String[]{ROCK_LAYER_UID});
                registry.addRecipeCatalyst((Object)new ItemStack(ItemMetalTool.get(metal2, Metal.ItemType.PROPICK)), new String[]{VEIN_UID});
            }
            for (Metal.ItemType type : Metal.ItemType.values()) {
                if (!type.hasMold(metal2)) continue;
                unmoldList.add(new UnmoldRecipeWrapper(metal2, type));
                castingList.add(new CastingRecipeWrapper(metal2, type));
            }
        }
        registry.addRecipes(unmoldList, "minecraft.crafting");
        registry.addRecipes(castingList, CASTING_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlocksTFC.CRUCIBLE), new String[]{CASTING_UID});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ItemsTFC.FIRED_VESSEL), new String[]{CASTING_UID});
        registry.addRecipeClickArea(GuiKnapping.class, 97, 44, 22, 15, new String[]{KNAP_CLAY_UID, KNAP_FIRECLAY_UID, KNAP_LEATHER_UID, KNAP_STONE_UID});
        registry.addRecipeClickArea(GuiAnvilTFC.class, 26, 24, 9, 14, new String[]{ANVIL_UID, WELDING_UID});
        registry.addRecipeClickArea(GuiBarrel.class, 92, 21, 9, 14, new String[]{BARREL_UID});
        registry.addRecipeClickArea(GuiCrucible.class, 139, 100, 10, 15, new String[]{ALLOY_UID});
        registry.addRecipeClickArea(GuiCrucible.class, 82, 100, 10, 15, new String[]{METAL_HEAT_UID});
        registry.addRecipeClickArea(GuiFirePit.class, 79, 37, 18, 10, new String[]{HEAT_UID});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TFCInventoryGuiHandler<GuiInventory>(GuiInventory.class)});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TFCInventoryGuiHandler<GuiCalendar>(GuiCalendar.class)});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TFCInventoryGuiHandler<GuiNutrition>(GuiNutrition.class)});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TFCInventoryGuiHandler<GuiSkills>(GuiSkills.class)});
        registry.addIngredientInfo((Object)new ItemStack((Block)BlocksTFC.PIT_KILN, 1), VanillaTypes.ITEM, new String[]{new TextComponentTranslation("jei.description.tfc.pit_kiln", new Object[0]).func_150254_d()});
        registry.addIngredientInfo((Object)new ItemStack((Block)BlocksTFC.PLACED_ITEM, 1), VanillaTypes.ITEM, new String[]{new TextComponentTranslation("jei.description.tfc.placed_item", new Object[0]).func_150254_d()});
        registry.addIngredientInfo((Object)new ItemStack(Items.field_151044_h, 1, 1), VanillaTypes.ITEM, new String[]{new TextComponentTranslation("jei.description.tfc.charcoal_pit", new Object[0]).func_150254_d()});
        registry.handleRecipes(SaltingRecipe.class, SaltingRecipeWrapper::new, "minecraft.crafting");
        IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
        transferRegistry.addRecipeTransferHandler(ContainerInventoryCrafting.class, "minecraft.crafting", 1, 9, 10, 36);
    }
}

