/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipeSimple;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.ClayKnapping")
@ZenRegister
public class CTClayKnapping {
    @ZenMethod
    public static void addRecipe(String registryName, IItemStack output, String ... pattern) {
        if (output == null || pattern.length < 1 || pattern.length > 5) {
            throw new IllegalArgumentException("Output item must be non-null and pattern must be a closed interval [1, 5]");
        }
        ItemStack outputStack = (ItemStack)output.getInternal();
        final KnappingRecipe recipe = (KnappingRecipe)new KnappingRecipeSimple(KnappingType.CLAY, true, outputStack, pattern).setRegistryName(registryName);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.KNAPPING.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding clay knapping recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack item = (ItemStack)output.getInternal();
        ArrayList removeList = new ArrayList();
        TFCRegistries.KNAPPING.getValuesCollection().stream().filter(x -> x.getType() == KnappingType.CLAY && x.getOutput(ItemStack.field_190927_a).func_77969_a(item)).forEach(removeList::add);
        for (final KnappingRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.KNAPPING;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing clay knapping recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final KnappingRecipe recipe = (KnappingRecipe)TFCRegistries.KNAPPING.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.KNAPPING;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing clay knapping recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

