/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.dries007.tfc.api.recipes.ChiselRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.Chisel")
@ZenRegister
public class CTChisel {
    @ZenMethod
    public static void addRecipe(String registryName, IItemStack input, IItemStack output) {
        if (output == null || input == null) {
            throw new IllegalArgumentException("Input and output are not allowed to be empty");
        }
        ItemStack ingredient = (ItemStack)input.getInternal();
        ItemStack outputStack = (ItemStack)output.getInternal();
        if (!(ingredient.func_77973_b() instanceof ItemBlock) || !(outputStack.func_77973_b() instanceof ItemBlock)) {
            throw new IllegalArgumentException("Input and output must be blocks!");
        }
        Block inputBlock = ((ItemBlock)ingredient.func_77973_b()).func_179223_d();
        Block outputBlock = ((ItemBlock)outputStack.func_77973_b()).func_179223_d();
        final ChiselRecipe recipe = (ChiselRecipe)new ChiselRecipe(inputBlock, outputBlock.func_176223_P()).setRegistryName(registryName);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.CHISEL.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding chisel recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack outputStack = (ItemStack)output.getInternal();
        if (!(outputStack.func_77973_b() instanceof ItemBlock)) {
            throw new IllegalArgumentException("Output must be a block!");
        }
        Block outputBlock = ((ItemBlock)outputStack.func_77973_b()).func_179223_d();
        ItemStack item = (ItemStack)output.getInternal();
        ArrayList removeList = new ArrayList();
        TFCRegistries.CHISEL.getValuesCollection().stream().filter(x -> x.getOutputState().func_177230_c().equals(outputBlock)).forEach(removeList::add);
        for (final ChiselRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.CHISEL;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing chisel recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final ChiselRecipe recipe = (ChiselRecipe)TFCRegistries.CHISEL.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.CHISEL;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing chisel recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

