/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import net.dries007.tfc.api.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.BlastFurnace")
@ZenRegister
public class CTBlastFurnace {
    @ZenMethod
    public static void addRecipe(String outputMetal, String inputMetal, crafttweaker.api.item.IIngredient additive) {
        final Metal result = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(outputMetal)).findFirst().orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("Output metal specified not found!");
        }
        final Metal input = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(inputMetal)).findFirst().orElse(null);
        if (input == null) {
            throw new IllegalArgumentException("Input metal specified not found!");
        }
        if (BlastFurnaceRecipe.get(input) != null) {
            throw new IllegalStateException("Recipe for that input metal already exists!");
        }
        if (additive == null) {
            throw new IllegalArgumentException("Additive is not allowed to be empty");
        }
        if (additive instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        IIngredient ingredient = CTHelper.getInternalIngredient(additive);
        final BlastFurnaceRecipe recipe = new BlastFurnaceRecipe(result, input, ingredient);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.BLAST_FURNACE.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding blast furnace recipe for " + input.getRegistryName().func_110623_a() + " -> " + result.getRegistryName().func_110623_a();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(String inputMetal) {
        Metal input = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(inputMetal)).findFirst().orElse(null);
        if (input == null) {
            throw new IllegalArgumentException("Metal specified not found!");
        }
        final BlastFurnaceRecipe recipe = BlastFurnaceRecipe.get(input);
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.BLAST_FURNACE;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing blast furnace recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

