/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.forge.ForgeRule;
import net.dries007.tfc.util.skills.SmithingSkill;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.Anvil")
@ZenRegister
public class CTAnvil {
    @ZenMethod
    public static void addRecipe(String registryName, crafttweaker.api.item.IIngredient input, IItemStack output, int minTier, String skillTypeName, String ... rules) {
        if (output == null || input == null) {
            throw new IllegalArgumentException("Input and output are not allowed to be empty");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        IIngredient ingredient = CTHelper.getInternalIngredient(input);
        if (rules.length == 0 || rules.length > 3) {
            throw new IllegalArgumentException("Rules length must be within the closed interval [1, 3]");
        }
        ForgeRule[] forgeRules = new ForgeRule[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            ForgeRule rl;
            String str = rules[i];
            forgeRules[i] = rl = ForgeRule.valueOf(str.toUpperCase());
        }
        Metal.Tier tier = Metal.Tier.valueOf(minTier);
        final ItemStack outputItem = (ItemStack)output.getInternal();
        SmithingSkill.Type skillType = null;
        if (skillTypeName != null) {
            skillType = SmithingSkill.Type.valueOf(skillTypeName.toUpperCase());
        }
        final AnvilRecipe recipe = new AnvilRecipe(new ResourceLocation(registryName), ingredient, outputItem, tier, skillType, forgeRules);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.ANVIL.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding anvil recipe for " + outputItem.func_82833_r();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack item = (ItemStack)output.getInternal();
        ArrayList removeList = new ArrayList();
        TFCRegistries.ANVIL.getValuesCollection().stream().filter(x -> ((ItemStack)x.getOutputs().get(0)).func_77969_a(item)).forEach(removeList::add);
        for (final AnvilRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.ANVIL;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing anvil recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final AnvilRecipe recipe = (AnvilRecipe)TFCRegistries.ANVIL.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.ANVIL;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing anvil recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

