/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CommandTimeTFC
extends CommandBase {
    public String func_71517_b() {
        return "timetfc";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tfc.command.timetfc.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) throw new WrongUsageException("tfc.command.timetfc.usage_expected_first_argument", new Object[0]);
        if ("set".equals(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("tfc.command.timetfc.usage_expected_second_argument_set", new Object[0]);
            }
            if ("monthlength".equals(args[1])) {
                int newMonthLength = CommandTimeTFC.func_180528_a((String)args[2], (int)1);
                CalendarTFC.INSTANCE.setMonthLength(newMonthLength);
                CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.set_month_length", (Object[])new Object[]{newMonthLength});
                return;
            } else {
                int resultWorldTime;
                if ("day".equals(args[1])) {
                    resultWorldTime = 1000;
                    CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.set_day", (Object[])new Object[0]);
                } else if ("night".equals(args[1])) {
                    resultWorldTime = 13000;
                    CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.set_night", (Object[])new Object[0]);
                } else {
                    resultWorldTime = CommandTimeTFC.func_180528_a((String)args[1], (int)0);
                    CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.set_ticks", (Object[])new Object[]{resultWorldTime});
                }
                this.setAllWorldTimes(server, resultWorldTime);
                CalendarTFC.INSTANCE.setTimeFromWorldTime(resultWorldTime);
            }
            return;
        } else if ("add".equals(args[0])) {
            long timeToAdd;
            if (args.length < 2) {
                throw new WrongUsageException("tfc.command.timetfc.usage_expected_second_argument_add", new Object[0]);
            }
            switch (args[1]) {
                case "months": {
                    int months = CommandTimeTFC.func_180528_a((String)args[2], (int)0);
                    timeToAdd = 24000L * CalendarTFC.CALENDAR_TIME.getDaysInMonth() * (long)months;
                    CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.add_months", (Object[])new Object[]{months, timeToAdd});
                    break;
                }
                case "years": {
                    int years = CommandTimeTFC.func_180528_a((String)args[2], (int)0);
                    timeToAdd = 24000L * CalendarTFC.CALENDAR_TIME.getDaysInMonth() * 12L * (long)years;
                    CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.add_years", (Object[])new Object[]{years, timeToAdd});
                    break;
                }
                case "days": {
                    int days = CommandTimeTFC.func_180528_a((String)args[2], (int)0);
                    timeToAdd = 24000 * days;
                    CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.add_days", (Object[])new Object[]{days, timeToAdd});
                    break;
                }
                default: {
                    timeToAdd = CommandTimeTFC.func_180528_a((String)args[1], (int)0);
                    CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.add_ticks", (Object[])new Object[]{timeToAdd});
                }
            }
            long newCalendarTime = CalendarTFC.CALENDAR_TIME.getTicks() + timeToAdd;
            CalendarTFC.INSTANCE.setTimeFromCalendarTime(newCalendarTime);
            return;
        } else {
            if (!"query".equals(args[0])) throw new WrongUsageException("tfc.command.timetfc.usage_expected_first_argument", new Object[0]);
            if (args.length < 2) {
                throw new WrongUsageException("tfc.command.timetfc.usage_expected_second_argument_query", new Object[0]);
            }
            if ("daytime".equals(args[1])) {
                int daytime = (int)(sender.func_130014_f_().func_72820_D() % 24000L);
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, daytime);
                CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.query_daytime", (Object[])new Object[]{daytime});
                return;
            } else if ("day".equals(args[1])) {
                int day = (int)(CalendarTFC.CALENDAR_TIME.getTotalDays() % Integer.MAX_VALUE);
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, day);
                CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.query_day", (Object[])new Object[]{day});
                return;
            } else if ("gametime".equals(args[1])) {
                int gameTime = (int)(sender.func_130014_f_().func_82737_E() % Integer.MAX_VALUE);
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, gameTime);
                CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.query_gametime", (Object[])new Object[]{gameTime});
                return;
            } else if ("playerticks".equals(args[1])) {
                int gameTime = (int)(CalendarTFC.PLAYER_TIME.getTicks() % Integer.MAX_VALUE);
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, gameTime);
                CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.query_playerticks", (Object[])new Object[]{gameTime});
                return;
            } else {
                if (!"calendarticks".equals(args[1])) throw new WrongUsageException("tfc.command.timetfc.usage_expected_second_argument_query", new Object[0]);
                int gameTime = (int)(CalendarTFC.CALENDAR_TIME.getTicks() % Integer.MAX_VALUE);
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, gameTime);
                CommandTimeTFC.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"tfc.command.timetfc.query_calendarticks", (Object[])new Object[]{gameTime});
            }
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTimeTFC.func_71530_a((String[])args, (String[])new String[]{"set", "add", "query"});
        }
        if (args.length == 2) {
            if ("set".equals(args[0])) {
                return CommandTimeTFC.func_71530_a((String[])args, (String[])new String[]{"day", "night", "monthlength"});
            }
            if ("add".equals(args[0])) {
                return CommandTimeTFC.func_71530_a((String[])args, (String[])new String[]{"months", "years", "days"});
            }
            if ("query".equals(args[0])) {
                return CommandTimeTFC.func_71530_a((String[])args, (String[])new String[]{"daytime", "day", "gametime", "playerticks", "calendarticks"});
            }
        }
        return Collections.emptyList();
    }

    private void setAllWorldTimes(MinecraftServer server, long worldTime) {
        for (WorldServer world : server.field_71305_c) {
            long worldTimeJump = worldTime - world.func_72820_D() % 24000L;
            if (worldTimeJump < 0L) {
                worldTimeJump += 24000L;
            }
            world.func_72877_b(world.func_72820_D() + worldTimeJump);
        }
    }
}

