/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

@ParametersAreNonnullByDefault
public class CommandStripWorld
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "stripworld";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "tfc.command.stripworld.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException("tfc.command.stripworld.failed", new Object[0]);
        }
        int radius = CommandStripWorld.func_175764_a((String)args[0], (int)1, (int)250);
        if (sender.func_174793_f() == null) {
            return;
        }
        World world = sender.func_130014_f_();
        BlockPos center = new BlockPos(sender.func_174793_f());
        IBlockState fluidReplacement = Blocks.field_150359_w.func_176223_P();
        IBlockState terrainReplacement = Blocks.field_150350_a.func_176223_P();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                for (int y = 255 - center.func_177956_o(); y > -center.func_177956_o(); --y) {
                    BlockPos pos = center.func_177982_a(x, y, z);
                    Block current = world.func_180495_p(pos).func_177230_c();
                    if (current instanceof BlockFluidBase || current instanceof BlockDynamicLiquid || current instanceof BlockStaticLiquid) {
                        world.func_180501_a(pos, fluidReplacement, 2);
                        continue;
                    }
                    if (!(current instanceof BlockRockVariant) && !(current instanceof BlockPlantTFC)) continue;
                    world.func_180501_a(pos, terrainReplacement, 2);
                }
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.stripworld.done", new Object[0]));
    }

    public int func_82362_a() {
        return 2;
    }
}

