/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.command;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.vein.VeinRegistry;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.WorldWorkerManager;

@ParametersAreNonnullByDefault
public class CommandFindVeins
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "findveins";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "tfc.command.findveins.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        VeinType filter;
        if (sender.func_174793_f() == null) {
            throw new WrongUsageException("tfc.command.findveins.usage_expected_player", new Object[0]);
        }
        if (args.length != 2 && args.length != 3) {
            throw new WrongUsageException("tfc.command.findveins.usage", new Object[0]);
        }
        if ("all".equals(args[0])) {
            filter = null;
        } else {
            filter = VeinRegistry.INSTANCE.getVein(args[0]);
            if (filter == null) {
                throw new WrongUsageException("tfc.command.findveins.usage_first_argument_not_vein", new Object[]{args[0]});
            }
        }
        LinkedList<ChunkPos> chunks = new LinkedList<ChunkPos>();
        int type = 0;
        boolean generated = false;
        if (args.length >= 3) {
            generated = true;
            if (args[2].equalsIgnoreCase("dump")) {
                type = 1;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.dump_veins", new Object[0]));
            } else if (args[2].equalsIgnoreCase("rate")) {
                type = 2;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.rate_veins", new Object[0]));
            } else {
                throw new WrongUsageException("tfc.command.findveins.usage", new Object[0]);
            }
        }
        int radius = CommandFindVeins.func_175764_a((String)args[1], (int)1, (int)1000);
        int chunkX = sender.func_174793_f().field_70176_ah;
        int chunkZ = sender.func_174793_f().field_70164_aj;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                pos.func_181079_c(x * 16, 0, z * 16);
                if (!sender.func_130014_f_().func_175667_e((BlockPos)pos) && (!generated || !sender.func_130014_f_().func_190526_b(x, z))) continue;
                chunks.add(new ChunkPos((BlockPos)pos));
            }
        }
        Worker worker = new Worker(sender, chunks, filter, type);
        WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)worker);
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandFindVeins.func_175762_a((String[])args, VeinRegistry.INSTANCE.keySet());
        }
        if (args.length == 3) {
            return CommandFindVeins.func_71530_a((String[])args, (String[])new String[]{"dump", "rate"});
        }
        return Collections.emptyList();
    }

    private static class Worker
    implements WorldWorkerManager.IWorker {
        private static final int DIMENSION = 0;
        private final ICommandSender listener;
        private final List<ChunkPos> chunks;
        private final int jobSize;
        private final VeinType filter;
        private final Set<BlockPos> veinsFound = new HashSet<BlockPos>();
        private final int type;
        private final List<String> outputLog = new ArrayList<String>();
        private final TObjectIntHashMap<VeinType> veinRateMap = new TObjectIntHashMap();
        private final TObjectIntHashMap<Rock> rockRateMap = new TObjectIntHashMap();
        private long lastNotifcationTime;
        private Boolean keepingLoaded;

        public Worker(@Nonnull ICommandSender listener, @Nonnull List<ChunkPos> chunks, @Nullable VeinType filter, int type) {
            this.listener = listener;
            this.chunks = chunks;
            this.jobSize = chunks.size();
            this.type = type;
            this.filter = filter;
            this.lastNotifcationTime = 0L;
            this.keepingLoaded = false;
        }

        public boolean hasWork() {
            return this.chunks.size() > 0;
        }

        public boolean doWork() {
            AnvilChunkLoader loader;
            WorldServer world = DimensionManager.getWorld((int)0);
            if (world == null) {
                DimensionManager.initDimension((int)0);
                world = DimensionManager.getWorld((int)0);
                if (world == null) {
                    this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.failed", new Object[]{0}));
                    this.chunks.clear();
                    return false;
                }
            }
            AnvilChunkLoader anvilChunkLoader = loader = world.func_72863_F().field_73247_e instanceof AnvilChunkLoader ? (AnvilChunkLoader)world.func_72863_F().field_73247_e : null;
            if (loader != null && loader.getPendingSaveCount() > 100) {
                if (this.lastNotifcationTime < System.currentTimeMillis() - 10000L) {
                    if (this.type > 0) {
                        this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.remaining_chunks", new Object[]{this.chunks.size(), this.jobSize}));
                    }
                    this.lastNotifcationTime = System.currentTimeMillis();
                }
                return false;
            }
            ChunkPos next = this.chunks.remove(0);
            if (next != null) {
                PlayerChunkMapEntry watchers;
                if (this.lastNotifcationTime < System.currentTimeMillis() - 5000L) {
                    if (this.type > 0) {
                        this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.remaining_chunks", new Object[]{this.chunks.size(), this.jobSize}));
                    }
                    this.lastNotifcationTime = System.currentTimeMillis();
                }
                if (!this.keepingLoaded.booleanValue()) {
                    this.keepingLoaded = DimensionManager.keepDimensionLoaded((int)0, (boolean)true);
                }
                Chunk target = world.func_72964_e(next.field_77276_a, next.field_77275_b);
                ChunkDataTFC chunkData = ChunkDataTFC.get(target);
                chunkData.getGeneratedVeins().stream().filter(vein -> !this.veinsFound.contains(vein.getPos())).filter(vein -> this.filter == null || this.filter.equals(vein.getType())).forEach(vein -> {
                    this.veinsFound.add(vein.getPos());
                    String veinName = "Unregistered Vein";
                    if (vein.getType() != null) {
                        veinName = vein.getType().getRegistryName();
                    }
                    if (this.type == 0) {
                        this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.output", new Object[]{veinName, vein.getPos()}));
                    } else if (this.type == 1) {
                        this.outputLog.add(String.format("Found %s at %s", veinName, vein.getPos()));
                    } else if (this.type == 2 && vein.getType() != null) {
                        int count = 1;
                        if (this.veinRateMap.containsKey((Object)vein.getType())) {
                            count += this.veinRateMap.get((Object)vein.getType());
                        }
                        this.veinRateMap.put((Object)vein.getType(), count);
                    }
                });
                if (this.type == 2) {
                    Rock rock1 = chunkData.getRockLayer1(8, 8);
                    Rock rock2 = chunkData.getRockLayer2(8, 8);
                    Rock rock3 = chunkData.getRockLayer3(8, 8);
                    int value = 1;
                    if (this.rockRateMap.containsKey((Object)rock1)) {
                        value += this.rockRateMap.get((Object)rock1);
                    }
                    this.rockRateMap.put((Object)rock1, value);
                    value = 1;
                    if (this.rockRateMap.containsKey((Object)rock2)) {
                        value += this.rockRateMap.get((Object)rock2);
                    }
                    this.rockRateMap.put((Object)rock2, value);
                    value = 1;
                    if (this.rockRateMap.containsKey((Object)rock3)) {
                        value += this.rockRateMap.get((Object)rock3);
                    }
                    this.rockRateMap.put((Object)rock3, value);
                }
                if ((watchers = world.func_184164_w().func_187301_b(target.field_76635_g, target.field_76647_h)) == null) {
                    world.func_72863_F().func_189549_a(target);
                }
            }
            if (this.chunks.isEmpty()) {
                Throwable throwable;
                BufferedWriter writer;
                File file;
                String fileName;
                if (this.type == 1) {
                    fileName = "tfc-veins-dump.log";
                    file = new File("tfc-veins-dump.log");
                    try {
                        writer = new BufferedWriter(new FileWriter(file));
                        throwable = null;
                        try {
                            for (String line : this.outputLog) {
                                writer.write(line);
                                writer.newLine();
                            }
                            this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.output_file", new Object[]{file.getAbsolutePath()}));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (writer != null) {
                                if (throwable != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                        }
                    }
                    catch (IOException error) {
                        this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.output_file.error", new Object[]{error.toString()}));
                    }
                } else if (this.type == 2) {
                    fileName = "tfc-veins-rate.log";
                    file = new File("tfc-veins-rate.log");
                    try {
                        writer = new BufferedWriter(new FileWriter(file));
                        throwable = null;
                        try {
                            String line;
                            writer.write("Found Veins: ");
                            writer.newLine();
                            for (VeinType veinType : this.veinRateMap.keySet()) {
                                line = String.format("%s: %d", veinType.getRegistryName(), this.veinRateMap.get((Object)veinType));
                                writer.write(line);
                                writer.newLine();
                            }
                            writer.newLine();
                            writer.write("Found Rock Layers (chunks): ");
                            writer.newLine();
                            for (Rock rock : this.rockRateMap.keySet()) {
                                line = String.format("%s: %d", new Object[]{rock, this.rockRateMap.get((Object)rock)});
                                writer.write(line);
                                writer.newLine();
                            }
                            this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.output_file", new Object[]{file.getAbsolutePath()}));
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (writer != null) {
                                if (throwable != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                        }
                    }
                    catch (IOException error) {
                        this.listener.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.findveins.output_file.error", new Object[]{error.toString()}));
                    }
                }
                if (this.keepingLoaded.booleanValue()) {
                    DimensionManager.keepDimensionLoaded((int)0, (boolean)false);
                }
                return false;
            }
            return true;
        }
    }
}

