/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.animal;

import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.client.model.animal.ModelQuailTFC;
import net.dries007.tfc.objects.entity.animal.EntityQuailTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class RenderQuailTFC
extends RenderLiving<EntityQuailTFC> {
    private static final ResourceLocation FEMALE_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/quailf_young.png");
    private static final ResourceLocation FEMALE_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/quailf_old.png");
    private static final ResourceLocation MALE_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/quailm_young.png");
    private static final ResourceLocation MALE_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/quailm_old.png");
    private static final ResourceLocation CHICK_TEXTURE = new ResourceLocation("tfc", "textures/entity/animal/livestock/quail_chick.png");

    public RenderQuailTFC(RenderManager manager) {
        super(manager, (ModelBase)new ModelQuailTFC(), 0.3f);
    }

    public void doRender(EntityQuailTFC quail, double par2, double par4, double par6, float par8, float par9) {
        this.field_76989_e = (float)((double)0.15f + quail.getPercentToAdulthood() * (double)0.15f);
        super.func_76986_a((EntityLiving)quail, par2, par4, par6, par8, par9);
    }

    protected ResourceLocation getEntityTexture(EntityQuailTFC quail) {
        float percent = (float)quail.getPercentToAdulthood();
        if (percent < 0.65f) {
            return CHICK_TEXTURE;
        }
        if (quail.getGender() == IAnimalTFC.Gender.MALE) {
            return quail.getAge() == IAnimalTFC.Age.OLD ? MALE_OLD : MALE_YOUNG;
        }
        return quail.getAge() == IAnimalTFC.Age.OLD ? FEMALE_OLD : FEMALE_YOUNG;
    }

    protected float handleRotationFloat(EntityQuailTFC livingBase, float partialTicks) {
        float f = livingBase.oFlap + (livingBase.wingRotation - livingBase.oFlap) * partialTicks;
        float f1 = livingBase.oFlapSpeed + (livingBase.destPos - livingBase.oFlapSpeed) * partialTicks;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected void preRenderCallback(EntityQuailTFC quail, float par2) {
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
    }
}

