/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.animal;

import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.client.model.animal.ModelPheasantTFC;
import net.dries007.tfc.objects.entity.animal.EntityPheasantTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class RenderPheasantTFC
extends RenderLiving<EntityPheasantTFC> {
    private static final ResourceLocation CHICK_TEXTURE = new ResourceLocation("tfc", "textures/entity/animal/huntable/pheasant_chick.png");
    private static final ResourceLocation MALE_TEXTURE = new ResourceLocation("tfc", "textures/entity/animal/huntable/pheasant_male.png");
    private static final ResourceLocation FEMALE_TEXTURE = new ResourceLocation("tfc", "textures/entity/animal/huntable/pheasant_female.png");

    public RenderPheasantTFC(RenderManager manager) {
        super(manager, (ModelBase)new ModelPheasantTFC(), 0.3f);
    }

    public void doRender(EntityPheasantTFC pheasent, double par2, double par4, double par6, float par8, float par9) {
        this.field_76989_e = (float)((double)0.15f + pheasent.getPercentToAdulthood() * (double)0.15f);
        super.func_76986_a((EntityLiving)pheasent, par2, par4, par6, par8, par9);
    }

    protected ResourceLocation getEntityTexture(EntityPheasantTFC pheasent) {
        float percent = (float)pheasent.getPercentToAdulthood();
        if (percent < 0.65f) {
            return CHICK_TEXTURE;
        }
        if (pheasent.getGender() == IAnimalTFC.Gender.MALE) {
            return MALE_TEXTURE;
        }
        return FEMALE_TEXTURE;
    }

    protected float handleRotationFloat(EntityPheasantTFC livingBase, float partialTicks) {
        float f = livingBase.oFlap + (livingBase.wingRotation - livingBase.oFlap) * partialTicks;
        float f1 = livingBase.oFlapSpeed + (livingBase.destPos - livingBase.oFlapSpeed) * partialTicks;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected void preRenderCallback(EntityPheasantTFC bear, float par2) {
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

