/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.animal;

import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.client.model.animal.ModelGrouseTFC;
import net.dries007.tfc.objects.entity.animal.EntityGrouseTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class RenderGrouseTFC
extends RenderLiving<EntityGrouseTFC> {
    private static final ResourceLocation FEMALE_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/grousef_young.png");
    private static final ResourceLocation FEMALE_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/grousef_old.png");
    private static final ResourceLocation MALE_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/grousem_young.png");
    private static final ResourceLocation MALE_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/grousem_old.png");
    private static final ResourceLocation CHICK_TEXTURE = new ResourceLocation("tfc", "textures/entity/animal/livestock/grouse_chick.png");

    public RenderGrouseTFC(RenderManager manager) {
        super(manager, (ModelBase)new ModelGrouseTFC(), 0.3f);
    }

    public void doRender(EntityGrouseTFC grouse, double par2, double par4, double par6, float par8, float par9) {
        this.field_76989_e = (float)((double)0.15f + grouse.getPercentToAdulthood() * (double)0.15f);
        super.func_76986_a((EntityLiving)grouse, par2, par4, par6, par8, par9);
    }

    protected ResourceLocation getEntityTexture(EntityGrouseTFC grouse) {
        float percent = (float)grouse.getPercentToAdulthood();
        if (percent < 0.65f) {
            return CHICK_TEXTURE;
        }
        if (grouse.getGender() == IAnimalTFC.Gender.MALE) {
            return grouse.getAge() == IAnimalTFC.Age.OLD ? MALE_YOUNG : MALE_OLD;
        }
        return grouse.getAge() == IAnimalTFC.Age.OLD ? FEMALE_YOUNG : FEMALE_OLD;
    }

    protected float handleRotationFloat(EntityGrouseTFC livingBase, float partialTicks) {
        float f = livingBase.oFlap + (livingBase.wingRotation - livingBase.oFlap) * partialTicks;
        float f1 = livingBase.oFlapSpeed + (livingBase.destPos - livingBase.oFlapSpeed) * partialTicks;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected void preRenderCallback(EntityGrouseTFC grouse, float par2) {
        GlStateManager.func_179152_a((float)0.85f, (float)0.85f, (float)0.85f);
    }
}

