/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render;

import java.util.Random;
import net.dries007.tfc.client.FluidSpriteCache;
import net.dries007.tfc.objects.te.TESluice;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TESRSluice
extends TileEntitySpecialRenderer<TESluice> {
    private static final ItemStack GRAVEL = new ItemStack(Blocks.field_150351_n);
    private static final Random SOIL_NOISE = new Random();

    public void render(TESluice te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Fluid flowing = te.getFlowingFluid();
        if (flowing == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EnumFacing facing = te.getBlockFacing();
        switch (facing) {
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        int soilBlocks = Math.min((int)Math.ceil((double)te.getSoil() * 5.0 / 50.0), 5);
        for (int step = 0; step < 8; ++step) {
            double posX = 0.5;
            double posY = 0.95625 - 0.125 * (double)step;
            double posZ = 0.14375 + 0.25 * (double)step;
            for (int soiling = 1; soiling < soilBlocks; ++soiling) {
                SOIL_NOISE.setSeed(te.func_174877_v().func_177986_g() + (long)(soiling * 2) + (long)(step * 3));
                this.drawSoil(posX - 0.1 * (double)soiling, posY, posZ, SOIL_NOISE.nextFloat() * 360.0f);
                this.drawSoil(posX + 0.1 * (double)soiling, posY, posZ, SOIL_NOISE.nextFloat() * 360.0f);
            }
            if (te.getSoil() <= 0) continue;
            SOIL_NOISE.setSeed(te.func_174877_v().func_177986_g() - 565L + (long)(step * 4));
            this.drawSoil(posX, posY, posZ, SOIL_NOISE.nextFloat() * 360.0f);
        }
        this.field_147501_a.field_147553_e.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite sprite = FluidSpriteCache.getFlowingSprite(flowing);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int color = flowing.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(9, DefaultVertexFormats.field_181710_j);
        buffer.func_181662_b(0.05, 1.033, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.05, -0.15, 2.45).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.95, -0.15, 2.45).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.95, 1.033, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        buffer.func_181668_a(9, DefaultVertexFormats.field_181710_j);
        buffer.func_181662_b(0.05, 0.833, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.05, -0.3, 2.45).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.95, -0.3, 2.45).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.95, 0.833, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        buffer.func_181668_a(9, DefaultVertexFormats.field_181710_j);
        buffer.func_181662_b(0.05, -0.15, 2.45).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.05, 1.033, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.05, 0.833, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.05, -0.3, 2.45).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        buffer.func_181668_a(9, DefaultVertexFormats.field_181710_j);
        buffer.func_181662_b(0.95, 1.033, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.95, -0.15, 2.45).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.95, -0.3, 2.45).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.95, 0.833, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(TESluice te) {
        return true;
    }

    private void drawSoil(double posX, double posY, double posZ, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.1, (double)0.1, (double)0.1);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(GRAVEL, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }
}

