/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render;

import net.dries007.tfc.objects.te.TEPitKiln;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@SideOnly(value=Side.CLIENT)
public class TESRPitKiln
extends TileEntitySpecialRenderer<TEPitKiln> {
    private static final ResourceLocation THATCH = new ResourceLocation("tfc", "textures/blocks/thatch.png");
    private static final ResourceLocation BARK = new ResourceLocation("tfc", "textures/blocks/wood/log/oak.png");
    private static final ModelStraw[] STRAW = new ModelStraw[8];
    private static final int LOG_ROWS = 2;
    private static final int LOGS_PER_ROW = 4;
    private static final ModelLog LOG = new ModelLog();
    private static final float SCALE = 0.0625f;

    public void render(TEPitKiln te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        World world = te.func_145831_w();
        if (world == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179094_E();
        IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (cap != null) {
            int logs;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            GlStateManager.func_179137_b((double)0.25, (double)0.25, (double)0.25);
            RenderHelper.func_74519_b();
            GlStateManager.func_179123_a();
            if (te.holdingLargeItem()) {
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                ItemStack stack = cap.getStackInSlot(0);
                if (!stack.func_190926_b()) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.25, (double)-0.001, (double)0.25);
                    GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
            } else {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                for (int i = 0; i < cap.getSlots(); ++i) {
                    ItemStack stack = cap.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(i % 2 == 0 ? 1 : 0), (double)-0.001, (double)(i < 2 ? 1 : 0));
                    GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                    renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                    GlStateManager.func_179121_F();
                }
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
            int straw = te.getStrawCount();
            if (straw != 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179123_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179091_B();
                this.func_147499_a(THATCH);
                STRAW[straw - 1].func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179099_b();
                GlStateManager.func_179121_F();
            }
            if ((logs = te.getLogCount()) != 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179123_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179091_B();
                GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
                this.func_147499_a(BARK);
                for (int row = 0; row < 2 && logs > 0; ++row) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)((double)row * 0.5 / 2.0), (double)0.0);
                    for (int i = 0; i < 4 && logs > 0; ++i, --logs) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((double)i / 4.0));
                        LOG.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179099_b();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
    }

    static {
        for (int i = 0; i < 8; ++i) {
            TESRPitKiln.STRAW[i] = new ModelStraw(i);
        }
    }

    private static class ModelLog
    extends ModelBase {
        private final ModelRenderer logRenderer;

        public ModelLog() {
            this.field_78089_u = 16;
            this.field_78090_t = 16;
            this.logRenderer = new ModelRenderer((ModelBase)this, 0, 0);
            this.logRenderer.func_78789_a(0.0f, 0.0f, 0.0f, 16, 4, 4);
        }

        public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            this.logRenderer.func_78785_a(scale);
        }
    }

    private static class ModelStraw
    extends ModelBase {
        private final ModelRenderer strawRenderer;

        public ModelStraw(int height) {
            this.field_78089_u = 16;
            this.field_78090_t = 16;
            this.strawRenderer = new ModelRenderer((ModelBase)this, 0, 0);
            this.strawRenderer.func_78789_a(0.0f, 0.0f, 0.0f, 16, height + 1, 16);
        }

        public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            this.strawRenderer.func_78785_a(scale);
        }
    }
}

