/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render;

import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.client.render.TESRBase;
import net.dries007.tfc.objects.te.TELoom;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TESRLoom
extends TESRBase<TELoom> {
    private static final Map<Tree, ResourceLocation> PLANKS_TEXTURES = new HashMap<Tree, ResourceLocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TELoom te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        BufferBuilder b;
        Tessellator t;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.03125), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)((float)(te.func_145832_p() & 3) * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179121_F();
        double tileZ = te.getAnimPos();
        try {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147499_a(PLANKS_TEXTURES.get((Object)te.getWood()));
            GlStateManager.func_179140_f();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
            GL11.glRotatef((float)(180.0f - 90.0f * (float)te.func_145832_p()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
            t = Tessellator.func_178181_a();
            b = t.func_178180_c();
            b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            if ("u".equals(te.getAnimElement())) {
                this.drawUpper(b, tileZ);
                this.drawLower(b, 0.0);
            } else {
                this.drawUpper(b, 0.0);
                this.drawLower(b, tileZ);
            }
            t.func_78381_a();
        }
        finally {
            GlStateManager.func_179121_F();
        }
        if (te.hasRecipe()) {
            try {
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_147499_a(te.getInProgressTexture());
                GlStateManager.func_179140_f();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
                GL11.glRotatef((float)(180.0f - 90.0f * (float)te.func_145832_p()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                t = Tessellator.func_178181_a();
                b = t.func_178180_c();
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                double Z = tileZ * 2.0 / 3.0;
                this.drawMaterial(b, te.getMaxInputCount(), te.getCount(), te.getMaxProgress(), te.getProgress(), "u".equals(te.getAnimElement()) ? Z : 0.0, "l".equals(te.getAnimElement()) ? Z : 0.0);
                this.drawProduct(b, te.getMaxProgress(), te.getProgress());
                t.func_78381_a();
            }
            finally {
                GlStateManager.func_179121_F();
            }
        }
    }

    public boolean isGlobalRenderer(TELoom te) {
        return false;
    }

    private void drawProduct(BufferBuilder b, int maxProgress, int progress) {
        double[][] sidesZ;
        for (double[] v : sidesZ = this.getPlaneVertices(0.1875, 0.9375, 0.749, 0.8125, 0.9375 - 0.625 / (double)maxProgress * (double)progress, 0.749, 0.0, 0.0, 1.0, (double)progress / 16.0)) {
            b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3], v[4]).func_181675_d();
        }
    }

    private void drawMaterial(BufferBuilder b, int maxPieces, int pieces, int maxProgress, int progress, double Z1, double Z2) {
        double y1 = 0.9375 - 0.625 / (double)maxProgress * (double)progress;
        double z1 = 0.75;
        for (int i = 0; i < pieces; ++i) {
            double[][] sidesZ;
            double y2;
            double z2;
            double texY2;
            double texX2;
            double texY1;
            double texX1;
            if (i % 2 == 0) {
                texX1 = 0.0;
                texY1 = 0.0;
                texX2 = 0.0625;
                texY2 = 0.125;
                z2 = 0.75 - Z1;
                y2 = 0.34375;
            } else {
                texX1 = 0.125;
                texY1 = 0.0;
                texX2 = 0.1875;
                texY2 = 0.1875;
                z2 = 0.75 - Z2;
                y2 = 0.125;
            }
            for (double[] v : sidesZ = this.getPlaneVertices(0.1875 + 0.625 / (double)maxPieces * (double)i, y1, z1 - 0.001, 0.1875 + 0.625 / (double)maxPieces * (double)(i + 1), y2, z2 - 0.001, texX1, texY1, texX2, texY2)) {
                b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3], v[4]).func_181675_d();
            }
            if (i % 2 == 0) {
                texX1 = 0.0;
                texY1 = 0.5;
                texX2 = 0.0625;
                texY2 = 0.5625;
            } else {
                texX1 = 0.125;
                texY1 = 0.5;
                texX2 = 0.1875;
                texY2 = 0.5625;
            }
            for (double[] v : sidesZ = this.getPlaneVertices(0.1875 + 0.625 / (double)maxPieces * (double)i, 0.0, z1 - 0.001, 0.1875 + 0.625 / (double)maxPieces * (double)(i + 1), y2, z2 - 0.001, texX1, texY1, texX2, texY2)) {
                b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3], v[4]).func_181675_d();
            }
        }
    }

    private double[][] getPlaneVertices(double X1, double Y1, double Z1, double X2, double Y2, double Z2, double texX1, double texY1, double texX2, double texY2) {
        return new double[][]{{X1, Y1, Z1, texX1, texY1}, {X2, Y1, Z1, texX2, texY1}, {X2, Y2, Z2, texX2, texY2}, {X1, Y2, Z2, texX1, texY2}, {X2, Y1, Z1, texX2, texY1}, {X1, Y1, Z1, texX1, texY1}, {X1, Y2, Z2, texX1, texY2}, {X2, Y2, Z2, texX2, texY2}};
    }

    private void drawUpper(BufferBuilder b, double z) {
        double[][] sidesZ;
        double[][] sidesY;
        double[][] sidesX;
        for (double[] v : sidesX = TESRLoom.getVerticesBySide(0.0625, 0.3125, 0.5626 - z, 0.9375, 0.375, 0.625 - z, "x")) {
            b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3] * 0.0625, v[4] * 0.0625).func_181675_d();
        }
        for (double[] v : sidesY = TESRLoom.getVerticesBySide(0.0625, 0.3125, 0.5626 - z, 0.9375, 0.375, 0.625 - z, "y")) {
            b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3] * 0.0625, v[4] * 0.875).func_181675_d();
        }
        for (double[] v : sidesZ = TESRLoom.getVerticesBySide(0.0625, 0.3125, 0.5626 - z, 0.9375, 0.375, 0.625 - z, "z")) {
            b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3] * 0.875, v[4] * 0.0625).func_181675_d();
        }
    }

    private void drawLower(BufferBuilder b, double z) {
        double[][] sidesZ;
        double[][] sidesY;
        double[][] sidesX;
        for (double[] v : sidesX = TESRLoom.getVerticesBySide(0.0625, 0.09375, 0.5626 - z, 0.9375, 0.15625, 0.625 - z, "x")) {
            b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3] * 0.0625, v[4] * 0.0625).func_181675_d();
        }
        for (double[] v : sidesY = TESRLoom.getVerticesBySide(0.0625, 0.09375, 0.5626 - z, 0.9375, 0.15625, 0.625 - z, "y")) {
            b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3] * 0.0625, v[4] * 0.875).func_181675_d();
        }
        for (double[] v : sidesZ = TESRLoom.getVerticesBySide(0.0625, 0.09375, 0.5626 - z, 0.9375, 0.15625, 0.625 - z, "z")) {
            b.func_181662_b(v[0], v[1], v[2]).func_187315_a(v[3] * 0.875, v[4] * 0.0625).func_181675_d();
        }
    }

    static {
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            PLANKS_TEXTURES.put(wood, new ResourceLocation("tfc", "textures/blocks/wood/planks/" + wood.getRegistryName().func_110623_a() + ".png"));
        }
    }
}

