/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render;

import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.wood.BlockChestTFC;
import net.dries007.tfc.objects.te.TEChestTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TESRChestTFC
extends TileEntitySpecialRenderer<TEChestTFC> {
    private static final Map<Tree, ResourceLocation> SINGLE_TEXTURES = new HashMap<Tree, ResourceLocation>();
    private static final Map<Tree, ResourceLocation> DOUBLE_TEXTURES = new HashMap<Tree, ResourceLocation>();
    private static final Map<Tree, ResourceLocation> TRAP_SINGLE_TEXTURES = new HashMap<Tree, ResourceLocation>();
    private static final Map<Tree, ResourceLocation> TRAP_DOUBLE_TEXTURES = new HashMap<Tree, ResourceLocation>();
    private final ModelChest simpleChest = new ModelChest();
    private final ModelChest largeChest = new ModelLargeChest();

    public void render(TEChestTFC te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float f2;
        float f1;
        ModelChest modelchest;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        int meta = 0;
        Tree wood = null;
        if (te.func_145830_o()) {
            Block block = te.func_145838_q();
            meta = te.func_145832_p();
            wood = te.getWood();
            if (block instanceof BlockChestTFC && meta == 0) {
                ((BlockChestTFC)block).func_176455_e(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()));
                meta = te.func_145832_p();
            }
            te.func_145979_i();
        }
        if (te.field_145992_i != null || te.field_145991_k != null) {
            return;
        }
        if (te.field_145990_j == null && te.field_145988_l == null) {
            modelchest = this.simpleChest;
            if (destroyStage >= 0) {
                this.func_147499_a(field_178460_a[destroyStage]);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.func_179128_n((int)5888);
            } else if (te.func_145980_j() == BlockChest.Type.TRAP && wood != null) {
                this.func_147499_a(TRAP_SINGLE_TEXTURES.get((Object)wood));
            } else if (wood != null) {
                this.func_147499_a(SINGLE_TEXTURES.get((Object)wood));
            }
        } else {
            modelchest = this.largeChest;
            if (destroyStage >= 0) {
                this.func_147499_a(field_178460_a[destroyStage]);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)4.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.func_179128_n((int)5888);
            } else if (te.func_145980_j() == BlockChest.Type.TRAP && wood != null) {
                this.func_147499_a(TRAP_DOUBLE_TEXTURES.get((Object)wood));
            } else if (wood != null) {
                this.func_147499_a(DOUBLE_TEXTURES.get((Object)wood));
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (destroyStage < 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        int rotation = 0;
        switch (meta) {
            case 2: {
                rotation = 180;
                if (te.field_145990_j == null) break;
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 3: {
                rotation = 0;
                break;
            }
            case 4: {
                rotation = 90;
                break;
            }
            case 5: {
                rotation = -90;
                if (te.field_145988_l == null) break;
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
        }
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidAngle = te.field_145986_n + (te.field_145989_m - te.field_145986_n) * partialTicks;
        if (te.field_145992_i != null && (f1 = te.field_145992_i.field_145986_n + (te.field_145992_i.field_145989_m - te.field_145992_i.field_145986_n) * partialTicks) > lidAngle) {
            lidAngle = f1;
        }
        if (te.field_145991_k != null && (f2 = te.field_145991_k.field_145986_n + (te.field_145991_k.field_145989_m - te.field_145991_k.field_145986_n) * partialTicks) > lidAngle) {
            lidAngle = f2;
        }
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        modelchest.field_78234_a.field_78795_f = -(lidAngle * 1.5707964f);
        modelchest.func_78231_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    static {
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            SINGLE_TEXTURES.put(wood, new ResourceLocation("tfc", "textures/entity/chests/chest/" + wood.getRegistryName().func_110623_a() + ".png"));
            DOUBLE_TEXTURES.put(wood, new ResourceLocation("tfc", "textures/entity/chests/chest_double/" + wood.getRegistryName().func_110623_a() + ".png"));
            TRAP_SINGLE_TEXTURES.put(wood, new ResourceLocation("tfc", "textures/entity/chests/chest_trap/" + wood.getRegistryName().func_110623_a() + ".png"));
            TRAP_DOUBLE_TEXTURES.put(wood, new ResourceLocation("tfc", "textures/entity/chests/chest_trap_double/" + wood.getRegistryName().func_110623_a() + ".png"));
        }
    }
}

