/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.animal;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.objects.entity.animal.EntityPolarBearTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class ModelPolarBearTFC
extends ModelBase {
    private final ModelRenderer head;
    private final ModelRenderer rearbody;
    private final ModelRenderer frontbody;
    private final ModelRenderer ear2;
    private final ModelRenderer ear1;
    private final ModelRenderer nose;
    private final ModelRenderer tail;
    private final ModelRenderer leg1;
    private final ModelRenderer leg2;
    private final ModelRenderer leg3;
    private final ModelRenderer leg4;
    private final ModelRenderer paw1;
    private final ModelRenderer paw2;
    private final ModelRenderer paw3;
    private final ModelRenderer paw4;

    public ModelPolarBearTFC() {
        this.field_78090_t = 80;
        this.field_78089_u = 64;
        this.ear1 = new ModelRenderer((ModelBase)this, 26, 12);
        this.ear1.field_78809_i = true;
        this.ear1.func_78793_a(0.2f, -0.5f, 0.0f);
        this.ear1.func_78790_a(2.5f, -4.0f, 0.0f, 2, 2, 1, 0.0f);
        this.ear2 = new ModelRenderer((ModelBase)this, 26, 12);
        this.ear2.func_78793_a(-0.1f, -0.5f, 0.0f);
        this.ear2.func_78790_a(-4.5f, -4.0f, 0.0f, 2, 2, 1, 0.0f);
        this.head = new ModelRenderer((ModelBase)this, 0, 7);
        this.head.func_78793_a(0.0f, 9.0f, -16.0f);
        this.head.func_78790_a(-4.0f, -3.0f, -3.5f, 8, 7, 8, 0.0f);
        this.nose = new ModelRenderer((ModelBase)this, 7, 0);
        this.nose.func_78793_a(0.0f, 0.0f, -0.2f);
        this.nose.func_78790_a(-3.0f, 0.0f, -6.0f, 6, 4, 3, 0.0f);
        this.frontbody = new ModelRenderer((ModelBase)this, 28, 40);
        this.frontbody.func_78793_a(-2.0f, 8.6f, 12.0f);
        this.frontbody.func_78790_a(-5.0f, -25.0f, -6.0f, 14, 12, 12, 0.0f);
        this.setRotation(this.frontbody, 1.5707964f, 0.0f, 0.0f);
        this.rearbody = new ModelRenderer((ModelBase)this, 22, 13);
        this.rearbody.func_78793_a(-2.0f, 9.0f, 12.0f);
        this.rearbody.func_78790_a(-6.0f, -13.0f, -6.0f, 16, 14, 13, 0.0f);
        this.setRotation(this.rearbody, 1.5707964f, 0.0f, 0.0f);
        this.tail = new ModelRenderer((ModelBase)this, 45, 7);
        this.tail.func_78793_a(1.5f, 0.7f, 0.0f);
        this.tail.func_78790_a(-1.0f, -1.0f, -1.0f, 3, 3, 3, 0.0f);
        this.setRotation(this.tail, -0.3642502f, 0.0f, 0.0f);
        this.leg1 = new ModelRenderer((ModelBase)this, 1, 47);
        this.leg1.func_78793_a(-4.6f, 14.0f, 6.0f);
        this.leg1.func_78790_a(-2.0f, 0.0f, -2.0f, 5, 10, 7, 0.0f);
        this.leg2 = new ModelRenderer((ModelBase)this, 1, 47);
        this.leg2.func_78793_a(3.6f, 14.0f, 6.0f);
        this.leg2.func_78790_a(-2.0f, 0.0f, -2.0f, 5, 10, 7, 0.0f);
        this.leg3 = new ModelRenderer((ModelBase)this, 0, 28);
        this.leg3.func_78793_a(-4.6f, 14.0f, -8.0f);
        this.leg3.func_78790_a(-2.0f, 0.0f, -2.0f, 5, 10, 6, 0.0f);
        this.leg4 = new ModelRenderer((ModelBase)this, 0, 28);
        this.leg4.func_78793_a(3.6f, 14.0f, -8.0f);
        this.leg4.func_78790_a(-2.0f, 0.0f, -2.0f, 5, 10, 6, 0.0f);
        this.paw1 = new ModelRenderer((ModelBase)this, 0, 22);
        this.paw1.func_78793_a(-2.0f, 7.0f, -3.0f);
        this.paw1.func_78790_a(0.0f, 0.0f, 0.0f, 5, 3, 1, 0.0f);
        this.paw2 = new ModelRenderer((ModelBase)this, 0, 22);
        this.paw2.func_78793_a(-2.0f, 7.0f, -3.0f);
        this.paw2.func_78790_a(0.0f, 0.0f, 0.0f, 5, 3, 1, 0.0f);
        this.paw3 = new ModelRenderer((ModelBase)this, 12, 22);
        this.paw3.func_78793_a(-2.0f, 7.0f, -3.0f);
        this.paw3.func_78790_a(0.0f, 0.0f, 0.0f, 5, 3, 1, 0.0f);
        this.paw4 = new ModelRenderer((ModelBase)this, 12, 22);
        this.paw4.func_78793_a(-2.0f, 7.0f, -3.0f);
        this.paw4.func_78790_a(0.0f, 0.0f, 0.0f, 5, 3, 1, 0.0f);
        this.head.func_78792_a(this.ear1);
        this.head.func_78792_a(this.ear2);
        this.head.func_78792_a(this.nose);
        this.rearbody.func_78792_a(this.tail);
        this.leg1.func_78792_a(this.paw1);
        this.leg2.func_78792_a(this.paw2);
        this.leg3.func_78792_a(this.paw3);
        this.leg4.func_78792_a(this.paw4);
        this.leg1.field_78800_c -= 1.0f;
        this.leg2.field_78800_c += 1.0f;
        ModelRenderer var10000 = this.leg1;
        var10000.field_78798_e += 0.0f;
        var10000 = this.leg2;
        var10000.field_78798_e += 0.0f;
        this.leg3.field_78800_c -= 1.0f;
        this.leg4.field_78800_c += 1.0f;
        this.leg3.field_78798_e -= 1.0f;
        this.leg4.field_78798_e -= 1.0f;
    }

    public void func_78088_a(@Nonnull Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entity);
        if (((EntityAnimal)entity).func_70631_g_()) {
            double ageScale = 1.0;
            double percent = 1.0;
            if (entity instanceof IAnimalTFC) {
                percent = ((IAnimalTFC)entity).getPercentToAdulthood();
                ageScale = 1.0 / (2.0 - percent);
            }
            GlStateManager.func_179139_a((double)ageScale, (double)ageScale, (double)ageScale);
            GlStateManager.func_179137_b((double)0.0, (double)(1.5 - 1.5 * percent), (double)0.0);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
        this.head.func_78785_a(scale);
        this.rearbody.func_78785_a(scale);
        this.frontbody.func_78785_a(scale);
        this.leg1.func_78785_a(scale);
        this.leg2.func_78785_a(scale);
        this.leg3.func_78785_a(scale);
        this.leg4.func_78785_a(scale);
        GlStateManager.func_179121_F();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        this.head.field_78795_f = headPitch / 57.295776f;
        this.head.field_78796_g = netHeadYaw / 57.295776f;
        this.leg1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = ((EntityPolarBearTFC)entityIn).func_189795_r(ageInTicks);
        f1 *= f1;
        float f2 = 1.0f - f1;
        this.frontbody.field_78795_f = 1.5707964f - f1 * (float)Math.PI * 0.35f;
        this.frontbody.field_78797_d = 9.0f * f2 + 11.0f * f1;
        this.leg3.field_78797_d = 14.0f * f2 + -6.0f * f1;
        this.leg3.field_78798_e = -8.0f * f2 + -4.0f * f1;
        this.leg3.field_78795_f -= f1 * (float)Math.PI * 0.45f;
        this.leg4.field_78797_d = this.leg3.field_78797_d;
        this.leg4.field_78798_e = this.leg3.field_78798_e;
        this.leg4.field_78795_f -= f1 * (float)Math.PI * 0.45f;
        this.head.field_78797_d = 10.0f * f2 + -12.0f * f1;
        this.head.field_78798_e = -16.0f * f2 + -3.0f * f1;
        this.head.field_78795_f += f1 * (float)Math.PI * 0.15f;
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }
}

