/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui.overlay;

import java.awt.Color;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.food.IFoodStatsTFC;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.objects.items.metal.ItemMetalChisel;
import net.dries007.tfc.util.config.HealthDisplayFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class PlayerDataOverlay {
    private static final ResourceLocation ICONS = new ResourceLocation("tfc", "textures/gui/icons/overlay.png");
    private static final ResourceLocation MC_ICONS = new ResourceLocation("minecraft:textures/gui/icons.png");
    private static final PlayerDataOverlay INSTANCE = new PlayerDataOverlay();

    public static PlayerDataOverlay getInstance() {
        return INSTANCE;
    }

    private static void drawTexturedModalRect(float xCoord, float yCoord, int minU, int minV, int maxU, int maxV) {
        float textureScaleU = 0.00390625f;
        float textureScaleV = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + (float)maxV), 0.0).func_187315_a((double)((float)minU * textureScaleU), (double)((float)(minV + maxV) * textureScaleV)).func_181675_d();
        vb.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + (float)maxV), 0.0).func_187315_a((double)((float)(minU + maxU) * textureScaleU), (double)((float)(minV + maxV) * textureScaleV)).func_181675_d();
        vb.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + 0.0f), 0.0).func_187315_a((double)((float)(minU + maxU) * textureScaleU), (double)((float)minV * textureScaleV)).func_181675_d();
        vb.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), 0.0).func_187315_a((double)((float)minU * textureScaleU), (double)((float)minV * textureScaleV)).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayer player = mc.field_71439_g.field_71071_by.field_70458_d;
        GuiIngameForge.renderFood = ConfigTFC.Client.DISPLAY.useVanillaHunger;
        GuiIngameForge.renderHealth = ConfigTFC.Client.DISPLAY.useVanillaHealth;
        GuiIngameForge.renderArmor = ConfigTFC.Client.DISPLAY.useVanillaHealth;
        boolean bl = GuiIngameForge.renderExperiance = ConfigTFC.Client.DISPLAY.useVanillaHealth && ConfigTFC.Client.DISPLAY.hideThirstBar;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        FoodStats foodStats = player.func_71024_bL();
        float displayModifier = 1.0f;
        if (ConfigTFC.Client.DISPLAY.healthDisplayFormat == HealthDisplayFormat.TFC || ConfigTFC.Client.DISPLAY.healthDisplayFormat == HealthDisplayFormat.TFC_CURRENT_HEALTH) {
            displayModifier = 50.0f;
        }
        float baseMaxHealth = 20.0f * displayModifier;
        float currentThirst = 100.0f;
        if (foodStats instanceof IFoodStatsTFC) {
            IFoodStatsTFC foodStatsTFC = (IFoodStatsTFC)foodStats;
            baseMaxHealth = 20.0f * foodStatsTFC.getHealthModifier() * displayModifier;
            currentThirst = foodStatsTFC.getThirst();
        }
        if (!ConfigTFC.Client.DISPLAY.hideThirstBar || !ConfigTFC.Client.DISPLAY.useVanillaHunger) {
            GuiIngameForge.right_height += ConfigTFC.Client.DISPLAY.useVanillaHunger ? 6 : 10;
        }
        ScaledResolution sr = event.getResolution();
        FontRenderer fontrenderer = mc.field_71466_p;
        int healthRowHeight = sr.func_78328_b() - 40;
        int armorRowHeight = healthRowHeight - 10;
        int mid = sr.func_78326_a() / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(ICONS);
        if (mc.field_71442_b.func_78763_f()) {
            GL11.glEnable((int)3042);
            float foodLevel = player.func_71024_bL().func_75116_a();
            float percentFood = foodLevel / 20.0f;
            float percentThirst = currentThirst / 100.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!ConfigTFC.Client.DISPLAY.useVanillaHunger) {
                PlayerDataOverlay.drawTexturedModalRect(mid + 1, healthRowHeight, 0, 20, 90, 5);
                PlayerDataOverlay.drawTexturedModalRect(mid + 1, healthRowHeight, 0, 25, (int)(90.0f * percentFood), 5);
            }
            if (!ConfigTFC.Client.DISPLAY.hideThirstBar) {
                PlayerDataOverlay.drawTexturedModalRect(mid + 1, healthRowHeight + 5, 90, 20, 90, 5);
                PlayerDataOverlay.drawTexturedModalRect(mid + 1, healthRowHeight + 5, 90, 25, (int)(90.0f * percentThirst), 5);
            }
            if (!ConfigTFC.Client.DISPLAY.useVanillaHealth) {
                PlayerDataOverlay.drawTexturedModalRect(mid - 91, healthRowHeight, 0, 0, 90, 10);
                float curHealth = player.func_110143_aJ() * baseMaxHealth / 20.0f;
                float percentHealth = curHealth / baseMaxHealth;
                float surplusPercent = Math.max(percentHealth - 1.0f, 0.0f);
                int uSurplus = 90;
                if (percentHealth > 1.0f) {
                    percentHealth = 1.0f;
                }
                PlayerDataOverlay.drawTexturedModalRect(mid - 91, healthRowHeight, 0, 10, (int)(90.0f * percentHealth), 10);
                while (surplusPercent > 0.0f) {
                    float percent = Math.min(surplusPercent, 1.0f);
                    PlayerDataOverlay.drawTexturedModalRect(mid - 91, healthRowHeight, uSurplus, 10, (int)(90.0f * percent), 10);
                    surplusPercent -= 1.0f;
                    uSurplus = uSurplus == 90 ? 0 : 90;
                }
                String healthString = ConfigTFC.Client.DISPLAY.healthDisplayFormat.format(Float.valueOf(curHealth), Float.valueOf(baseMaxHealth));
                fontrenderer.func_78276_b(healthString, mid - 45 - fontrenderer.func_78256_a(healthString) / 2, healthRowHeight + 2, Color.white.getRGB());
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(MC_ICONS);
            if (!(player.func_184187_bx() instanceof EntityLiving) && !GuiIngameForge.renderExperiance) {
                int cap = player.func_71050_bK();
                int left = mid - 91;
                if (cap > 0) {
                    int barWidth = 182;
                    int filled = (int)(player.field_71106_cc * (float)(barWidth + 1));
                    int top = sr.func_78328_b() - 29;
                    PlayerDataOverlay.drawTexturedModalRect(left, top, 0, 64, barWidth, 5);
                    if (filled > 0) {
                        PlayerDataOverlay.drawTexturedModalRect(left, top, 0, 69, filled, 5);
                    }
                }
                if (player.field_71068_ca > 0) {
                    int color = 8453920;
                    String text = Integer.toString(player.field_71068_ca);
                    int x = (sr.func_78326_a() - fontrenderer.func_78256_a(text)) / 2;
                    int y = sr.func_78328_b() - 30;
                    fontrenderer.func_78276_b(text, x + 1, y, 0);
                    fontrenderer.func_78276_b(text, x - 1, y, 0);
                    fontrenderer.func_78276_b(text, x, y + 1, 0);
                    fontrenderer.func_78276_b(text, x, y - 1, 0);
                    fontrenderer.func_78276_b(text, x, y, color);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (player.func_184187_bx() instanceof EntityLivingBase && !ConfigTFC.Client.DISPLAY.useVanillaHealth) {
                GuiIngameForge.renderHealthMount = false;
                mc.field_71446_o.func_110577_a(ICONS);
                EntityLivingBase mount = (EntityLivingBase)player.func_184187_bx();
                PlayerDataOverlay.drawTexturedModalRect(mid + 1, armorRowHeight, 90, 0, 90, 10);
                double mountMaxHealth = mount.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
                double mountCurrentHealth = mount.func_110143_aJ();
                float mountPercentHealth = (float)Math.min(mountCurrentHealth / mountMaxHealth, 1.0);
                PlayerDataOverlay.drawTexturedModalRect(mid + 1, armorRowHeight, 90, 10, (int)(90.0f * mountPercentHealth), 10);
                String mountHealthString = (int)Math.min(mountCurrentHealth, mountMaxHealth) + "/" + (int)mountMaxHealth;
                fontrenderer.func_78276_b(mountHealthString, mid + 47 - fontrenderer.func_78256_a(mountHealthString) / 2, armorRowHeight + 2, Color.white.getRGB());
            }
            mc.field_71446_o.func_110577_a(MC_ICONS);
        }
        int itemModeY = sr.func_78328_b() - 21;
        int itemModeX = mid + 100;
        if (player.func_184614_ca().func_77973_b() instanceof ItemMetalChisel) {
            int iconU = 0;
            if (ItemMetalChisel.hasHammerForChisel(player)) {
                IPlayerData capability = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
                if (capability != null) {
                    switch (capability.getChiselMode()) {
                        case SMOOTH: {
                            iconU = 0;
                            break;
                        }
                        case STAIR: {
                            iconU = 20;
                            break;
                        }
                        case SLAB: {
                            iconU = 40;
                        }
                    }
                }
            } else {
                iconU = 60;
            }
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(ICONS);
            PlayerDataOverlay.drawTexturedModalRect(itemModeX, itemModeY, iconU, 58, 20, 20);
            mc.field_71446_o.func_110577_a(MC_ICONS);
        }
    }

    @SubscribeEvent
    public void renderAnimalFamiliarity(RenderLivingEvent.Post<EntityLiving> event) {
        EntityLivingBase entity;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayer player = mc.field_71439_g.field_71071_by.field_70458_d;
        if (player.func_70093_af() && (entity = event.getEntity()) instanceof IAnimalTFC && ((IAnimalTFC)entity).getAdultFamiliarityCap() > 0.0f && entity == mc.field_147125_j) {
            float f2;
            double x = event.getX();
            double y = event.getY();
            double z = event.getZ();
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            double d3 = entity.func_70032_d((Entity)player);
            if (d3 < (double)(f2 = 5.0f)) {
                IAnimalTFC animal = (IAnimalTFC)entity;
                RenderManager rendermanager = mc.func_175598_ae();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + entity.field_70131_O + 0.75f), (float)((float)z));
                GL11.glRotatef((float)(-rendermanager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)rendermanager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(ICONS);
                GL11.glScalef((float)0.33f, (float)0.33f, (float)0.33f);
                float familiarity = Math.max(0.0f, Math.min(1.0f, animal.getFamiliarity()));
                if (familiarity >= animal.getAdultFamiliarityCap() && animal.getAge() != IAnimalTFC.Age.CHILD) {
                    PlayerDataOverlay.drawTexturedModalRect(-8.0f, 0.0f, 132, 40, 16, 16);
                } else if (familiarity >= 0.3f) {
                    PlayerDataOverlay.drawTexturedModalRect(-8.0f, 0.0f, 112, 40, 16, 16);
                } else {
                    PlayerDataOverlay.drawTexturedModalRect(-8.0f, 0.0f, 92, 40, 16, 16);
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.001f);
                if (familiarity == 1.0f) {
                    PlayerDataOverlay.drawTexturedModalRect(-6.0f, 14 - (int)(12.0f * familiarity), 114, 74 - (int)(12.0f * familiarity), 12, (int)(12.0f * familiarity));
                } else {
                    PlayerDataOverlay.drawTexturedModalRect(-6.0f, 14 - (int)(12.0f * familiarity), 94, 74 - (int)(12.0f * familiarity), 12, (int)(12.0f * familiarity));
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }
}

