/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui.overlay;

import net.dries007.tfc.objects.items.metal.ItemMetalChisel;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IHighlightHandler {
    public static AxisAlignedBB getBox(EntityPlayer player, BlockPos pos, double partialTicks) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        return new AxisAlignedBB(pos).func_72317_d(-dx, -dy, -dz);
    }

    public static void drawBox(AxisAlignedBB box, float lineWidth, float red, float green, float blue, float alpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)lineWidth);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)red, (float)green, (float)blue, (float)alpha);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public boolean drawHighlight(World var1, BlockPos var2, EntityPlayer var3, RayTraceResult var4, double var5);

    @SideOnly(value=Side.CLIENT)
    @Mod.EventBusSubscriber(value={Side.CLIENT}, modid="tfc")
    public static final class EventHandler {
        @SubscribeEvent
        public static void drawHighlightEvent(DrawBlockHighlightEvent event) {
            EntityPlayer player = event.getPlayer();
            World world = player.func_130014_f_();
            RayTraceResult traceResult = event.getTarget();
            BlockPos lookingAt = traceResult.func_178782_a();
            if (lookingAt != null) {
                IHighlightHandler handler;
                if (event.getPlayer().func_184614_ca().func_77973_b() instanceof ItemMetalChisel) {
                    IBlockState newState = ItemMetalChisel.getChiselResultState(player, player.field_70170_p, lookingAt, traceResult.field_178784_b, (float)traceResult.field_72307_f.field_72450_a - (float)lookingAt.func_177958_n(), (float)traceResult.field_72307_f.field_72448_b - (float)lookingAt.func_177956_o(), (float)traceResult.field_72307_f.field_72449_c - (float)lookingAt.func_177952_p());
                    if (newState != null) {
                        AxisAlignedBB box = IHighlightHandler.getBox(player, lookingAt, event.getPartialTicks()).func_186662_g(0.001);
                        double offsetX = 0.0;
                        double offsetY = 0.0;
                        double offsetZ = 0.0;
                        if (newState.func_177230_c() instanceof BlockStairs) {
                            EnumFacing facing = (EnumFacing)newState.func_177229_b((IProperty)BlockStairs.field_176309_a);
                            offsetY = newState.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP ? -0.5 : 0.5;
                            offsetX = (double)(-facing.func_82601_c()) * 0.5;
                            offsetZ = (double)(-facing.func_82599_e()) * 0.5;
                        } else if (newState.func_177230_c() instanceof BlockSlab) {
                            offsetY = newState.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? -0.5 : 0.5;
                        }
                        box = box.func_191500_a(box.func_72317_d(offsetX, offsetY, offsetZ));
                        IHighlightHandler.drawBox(box, 5.0f, 1.0f, 0.0f, 0.0f, 0.8f);
                    }
                } else if (world.func_180495_p(lookingAt).func_177230_c() instanceof IHighlightHandler && (handler = (IHighlightHandler)world.func_180495_p(lookingAt).func_177230_c()).drawHighlight(world, lookingAt, player, traceResult, event.getPartialTicks())) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

