/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui;

import java.util.List;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.client.button.GuiButtonPage;
import net.dries007.tfc.client.button.GuiButtonPlayerInventoryTab;
import net.dries007.tfc.client.gui.GuiContainerTFC;
import net.dries007.tfc.network.PacketSwitchPlayerInventoryTab;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SkillType;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSkills
extends GuiContainerTFC {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tfc", "textures/gui/player_skills.png");
    private final String[] skillTooltips = new String[4];
    private final int[] skillBarWidths = new int[4];
    private final int[] skillBarColors = new int[4];
    private int currentPage = 0;
    private int skillsToDisplay;
    private GuiButton buttonLeft;
    private GuiButton buttonRight;

    public GuiSkills(Container container, InventoryPlayer playerInv) {
        super(container, playerInv, BACKGROUND);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int buttonId = 0;
        this.func_189646_b(new GuiButtonPlayerInventoryTab(TFCGuiHandler.Type.INVENTORY, this.field_147003_i, this.field_147009_r, ++buttonId, true));
        this.func_189646_b(new GuiButtonPlayerInventoryTab(TFCGuiHandler.Type.SKILLS, this.field_147003_i, this.field_147009_r, ++buttonId, false));
        this.func_189646_b(new GuiButtonPlayerInventoryTab(TFCGuiHandler.Type.CALENDAR, this.field_147003_i, this.field_147009_r, ++buttonId, true));
        this.func_189646_b(new GuiButtonPlayerInventoryTab(TFCGuiHandler.Type.NUTRITION, this.field_147003_i, this.field_147009_r, ++buttonId, true));
        this.buttonLeft = this.func_189646_b(new GuiButtonPage(++buttonId, this.field_147003_i + 7, this.field_147009_r + 68, GuiButtonPage.Type.LEFT, "tfc.tooltip.previous_page"));
        this.buttonRight = this.func_189646_b(new GuiButtonPage(++buttonId, this.field_147003_i + 154, this.field_147009_r + 68, GuiButtonPage.Type.RIGHT, "tfc.tooltip.next_page"));
        this.updateSkillValues();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (int i = 0; i < this.skillsToDisplay; ++i) {
            this.field_146289_q.func_78276_b(this.skillTooltips[i], 7, 5 + 16 * i, 0x404040);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        for (int i = 0; i < this.skillsToDisplay; ++i) {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 14 + 16 * i, 0, 166, 162, 5);
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 15 + 16 * i, 0, 171 + this.skillBarColors[i] * 3, this.skillBarWidths[i], 3);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiButtonPlayerInventoryTab && ((GuiButtonPlayerInventoryTab)button).isActive()) {
            GuiButtonPlayerInventoryTab tabButton = (GuiButtonPlayerInventoryTab)button;
            if (tabButton.isActive()) {
                if (tabButton.getGuiType() == TFCGuiHandler.Type.INVENTORY) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiInventory(this.playerInv.field_70458_d));
                }
                TerraFirmaCraft.getNetwork().sendToServer((IMessage)new PacketSwitchPlayerInventoryTab(tabButton.getGuiType()));
            }
        } else if (button == this.buttonLeft) {
            --this.currentPage;
            this.updateSkillValues();
        } else if (button == this.buttonRight) {
            ++this.currentPage;
            this.updateSkillValues();
        }
    }

    private void updateSkillValues() {
        this.skillsToDisplay = 0;
        this.buttonLeft.field_146124_l = this.currentPage >= 1;
        this.buttonRight.field_146124_l = false;
        IPlayerData skills = (IPlayerData)this.playerInv.field_70458_d.getCapability(CapabilityPlayerData.CAPABILITY, null);
        if (skills != null) {
            int startSkill = this.currentPage * 4;
            List<SkillType<Skill>> skillOrder = SkillType.getSkills();
            int totalSkills = skillOrder.size();
            if (startSkill >= totalSkills || startSkill < 0) {
                TerraFirmaCraft.getLog().warn("Invalid skill page! Page: {}, Start at: {}, Skill Order is: {}", (Object)this.currentPage, (Object)startSkill, skillOrder);
                return;
            }
            this.buttonRight.field_146124_l = startSkill + 4 < totalSkills;
            this.buttonLeft.field_146125_m = totalSkills > 4;
            this.buttonRight.field_146125_m = totalSkills > 4;
            this.skillsToDisplay = Math.min(4, totalSkills - startSkill);
            for (int i = 0; i < this.skillsToDisplay; ++i) {
                SkillType<Skill> skillType = skillOrder.get(startSkill + i);
                Skill skill = skills.getSkill(skillType);
                if (skill == null) continue;
                this.skillTooltips[i] = I18n.func_135052_a((String)("tfc.skill." + skillType.getName()), (Object[])new Object[]{I18n.func_135052_a((String)Helpers.getEnumName(skill.getTier()), (Object[])new Object[0])});
                this.skillBarWidths[i] = (int)(160.0f * skill.getLevel());
                this.skillBarColors[i] = skill.getTier().ordinal();
            }
        }
    }
}

