/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui;

import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.client.gui.GuiContainerTE;
import net.dries007.tfc.objects.blocks.devices.BlockFirePit;
import net.dries007.tfc.objects.te.TEFirePit;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiFirePit
extends GuiContainerTE<TEFirePit> {
    private static final ResourceLocation FIRE_PIT_BACKGROUND = new ResourceLocation("tfc", "textures/gui/fire_pit.png");
    private static final ResourceLocation FIRE_PIT_COOKING_POT_BACKGROUND = new ResourceLocation("tfc", "textures/gui/fire_pit_cooking_pot.png");
    private static final ResourceLocation FIRE_PIT_GRILL_BACKGROUND = new ResourceLocation("tfc", "textures/gui/fire_pit_grill.png");
    private final BlockFirePit.FirePitAttachment attachment;

    public GuiFirePit(Container container, InventoryPlayer playerInv, TEFirePit tile) {
        super(container, playerInv, tile, FIRE_PIT_BACKGROUND);
        this.attachment = (BlockFirePit.FirePitAttachment)((Object)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b(BlockFirePit.ATTACHMENT));
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground();
        int temperature = (int)((float)(51 * ((TEFirePit)this.tile).getField(0)) / Heat.maxVisibleTemperature());
        if (temperature > 0) {
            if (temperature > 51) {
                temperature = 51;
            }
            this.func_73729_b(this.field_147003_i + 30, this.field_147009_r + 66 - temperature, 176, 0, 15, 5);
        }
        if (this.attachment == BlockFirePit.FirePitAttachment.COOKING_POT) {
            String caption;
            TEFirePit.CookingPotStage stage = ((TEFirePit)this.tile).getCookingPotStage();
            if (stage == TEFirePit.CookingPotStage.WAITING || stage == TEFirePit.CookingPotStage.BOILING) {
                this.func_73729_b(this.field_147003_i + 58, this.field_147009_r + 52, 191, 0, 24, 4);
                caption = stage == TEFirePit.CookingPotStage.WAITING ? I18n.func_135052_a((String)"tfc.tooltip.firepit_cooking_pot_waiting", (Object[])new Object[0]) : I18n.func_135052_a((String)"tfc.tooltip.firepit_cooking_pot_boiling", (Object[])new Object[0]);
            } else if (stage == TEFirePit.CookingPotStage.FINISHED) {
                this.func_73729_b(this.field_147003_i + 58, this.field_147009_r + 52, 191, 4, 24, 4);
                caption = I18n.func_135052_a((String)"tfc.tooltip.firepit_cooking_pot_servings", (Object[])new Object[]{((TEFirePit)this.tile).getSoupServings()});
            } else {
                caption = I18n.func_135052_a((String)"tfc.tooltip.firepit_cooking_pot_empty", (Object[])new Object[0]);
            }
            this.field_146289_q.func_78276_b(caption, this.field_147003_i + 130 - this.field_146289_q.func_78256_a(caption) / 2, this.field_147009_r + 52, 0x404040);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        TEFirePit.CookingPotStage stage;
        super.func_146979_b(mouseX, mouseY);
        if (this.attachment == BlockFirePit.FirePitAttachment.COOKING_POT && ((stage = ((TEFirePit)this.tile).getCookingPotStage()) == TEFirePit.CookingPotStage.BOILING || stage == TEFirePit.CookingPotStage.FINISHED)) {
            GL11.glDisable((int)2929);
            for (int i = 7; i <= 11; ++i) {
                this.drawSlotOverlay(this.field_147002_h.func_75139_a(i - 3));
            }
            GL11.glEnable((int)2929);
        }
    }

    protected void drawBackground() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.attachment) {
            case NONE: {
                this.field_146297_k.func_110434_K().func_110577_a(FIRE_PIT_BACKGROUND);
                break;
            }
            case COOKING_POT: {
                this.field_146297_k.func_110434_K().func_110577_a(FIRE_PIT_COOKING_POT_BACKGROUND);
                break;
            }
            case GRILL: {
                this.field_146297_k.func_110434_K().func_110577_a(FIRE_PIT_GRILL_BACKGROUND);
            }
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

