/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui;

import com.google.common.base.Strings;
import com.google.gson.JsonParseException;
import java.io.IOException;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.world.classic.WorldGenSettings;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCustomizeWorld
extends GuiScreen
implements GuiSlider.FormatHelper,
GuiPageButtonList.GuiResponder {
    private static final int ID_DONE = 0;
    private static final int ID_CANCEL = 1;
    private static final int ID_DEFAULTS = 2;
    private static final int ID_SPAWN_FUZZ = 100;
    private static final int ID_FLAT_BEDROCK = 101;
    private static final int ID_RAVINE_RARITY = 102;
    private static final int ID_RAVINE_HEIGHT = 103;
    private static final int ID_RAVINE_VARIABILITY = 104;
    private static final int ID_SURFACE_RAVINE_RARITY = 105;
    private static final int ID_SURFACE_RAVINE_HEIGHT = 106;
    private static final int ID_SURFACE_RAVINE_VARIABILITY = 107;
    private static final int ID_RIVER_RAVINE_RARITY = 108;
    private final GuiCreateWorld parent;
    private String title;
    private GuiButton doneBtn;
    private GuiButton cancelBtn;
    private GuiButton defaultsBtn;
    private GuiPageButtonList list;
    private WorldGenSettings.WorldGenSettingsBuilder settings;

    public GuiCustomizeWorld(GuiCreateWorld guiCreateWorld, String prevSettings) {
        this.parent = guiCreateWorld;
        this.settings = this.loadSettings(prevSettings);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        this.list.func_178062_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.list.func_148179_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.list.func_148181_b(mouseX, mouseY, state);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (!button.field_146124_l) {
            return;
        }
        switch (button.field_146127_k) {
            case 0: {
                this.parent.field_146334_a = this.settings.build().toString();
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 2: {
                this.settings = this.loadSettings("");
            }
        }
        super.func_146284_a(button);
        this.update();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.title = I18n.func_135052_a((String)"options.customizeTitle", (Object[])new Object[0]);
        this.doneBtn = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.cancelBtn = this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.defaultsBtn = this.func_189646_b(new GuiButton(2, 20, 5, 80, 20, I18n.func_135052_a((String)"createWorld.customize.custom.defaults", (Object[])new Object[0])));
        GuiPageButtonList.GuiListEntry[] page1 = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiSlideEntry(100, I18n.func_135052_a((String)"createWorld.customize.custom.spawnfuzz", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 2500.0f, (float)this.settings.spawnFuzz), new GuiPageButtonList.GuiButtonEntry(101, I18n.func_135052_a((String)"createWorld.customize.custom.flatbedrock", (Object[])new Object[0]), true, this.settings.flatBedrock), new GuiPageButtonList.GuiSlideEntry(102, I18n.func_135052_a((String)"createWorld.customize.custom.ravineRarity", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 250.0f, (float)this.settings.ravineRarity), new GuiPageButtonList.GuiSlideEntry(103, I18n.func_135052_a((String)"createWorld.customize.custom.ravineHeight", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 50.0f, (float)this.settings.ravineHeight), new GuiPageButtonList.GuiSlideEntry(104, I18n.func_135052_a((String)"createWorld.customize.custom.ravineVariability", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 100.0f, (float)this.settings.ravineVariability), new GuiPageButtonList.GuiSlideEntry(105, I18n.func_135052_a((String)"createWorld.customize.custom.surfaceRavineRarity", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 250.0f, (float)this.settings.surfaceRavineRarity), new GuiPageButtonList.GuiSlideEntry(106, I18n.func_135052_a((String)"createWorld.customize.custom.surfaceRavineHeight", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 250.0f, (float)this.settings.surfaceRavineHeight), new GuiPageButtonList.GuiSlideEntry(107, I18n.func_135052_a((String)"createWorld.customize.custom.surfaceRavineVariability", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 100.0f, (float)this.settings.surfaceRavineVariability), new GuiPageButtonList.GuiSlideEntry(108, I18n.func_135052_a((String)"createWorld.customize.custom.riverRavineRarity", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 500.0f, (float)this.settings.riverRavineRarity)};
        this.list = new GuiPageButtonList(this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 32, 25, (GuiPageButtonList.GuiResponder)this, (GuiPageButtonList.GuiListEntry[][])new GuiPageButtonList.GuiListEntry[][]{page1});
        this.update();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    public void func_175321_a(int id, boolean value) {
        switch (id) {
            case 101: {
                this.settings.flatBedrock = value;
            }
        }
        this.update();
    }

    public void func_175320_a(int id, float value) {
        switch (id) {
            case 100: {
                this.settings.spawnFuzz = Math.round(value);
                break;
            }
            case 102: {
                this.settings.ravineRarity = Math.round(value);
                break;
            }
            case 103: {
                this.settings.ravineHeight = Math.round(value);
                break;
            }
            case 104: {
                this.settings.ravineVariability = Math.round(value);
                break;
            }
            case 105: {
                this.settings.surfaceRavineRarity = Math.round(value);
                break;
            }
            case 106: {
                this.settings.surfaceRavineHeight = Math.round(value);
                break;
            }
            case 107: {
                this.settings.surfaceRavineVariability = Math.round(value);
                break;
            }
            case 108: {
                this.settings.riverRavineRarity = Math.round(value);
            }
        }
        this.update();
    }

    public void func_175319_a(int id, String value) {
        this.update();
    }

    public String func_175318_a(int id, String name, float value) {
        return name + ": " + this.getFormattedValue(id, value);
    }

    private void update() {
        this.defaultsBtn.field_146124_l = !this.settings.isDefault();
    }

    private WorldGenSettings.WorldGenSettingsBuilder loadSettings(String str) {
        if (!Strings.isNullOrEmpty((String)str)) {
            try {
                return WorldGenSettings.fromString(str);
            }
            catch (JsonParseException e) {
                TerraFirmaCraft.getLog().error("Error parsing s: {}", (Object)str);
                TerraFirmaCraft.getLog().catching((Throwable)e);
            }
        }
        return new WorldGenSettings.WorldGenSettingsBuilder();
    }

    private String getFormattedValue(int id, float value) {
        switch (id) {
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return String.valueOf(Math.round(value));
            }
        }
        return String.valueOf(value);
    }
}

