/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.client.FluidSpriteCache;
import net.dries007.tfc.client.gui.GuiContainerTE;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.te.TECrucible;
import net.dries007.tfc.util.Alloy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.input.Mouse;

public class GuiCrucible
extends GuiContainerTE<TECrucible> {
    private static final ResourceLocation CRUCIBLE_BACKGROUND = new ResourceLocation("tfc", "textures/gui/crucible.png");
    private static final int MAX_ELEMENTS = 3;
    private int scrollPos;
    private boolean scrollPress;

    public GuiCrucible(Container container, InventoryPlayer playerInv, TECrucible tile) {
        super(container, playerInv, tile, CRUCIBLE_BACKGROUND);
        this.field_147000_g = 221;
        this.scrollPos = 0;
        this.scrollPress = false;
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (((TECrucible)this.tile).getAlloy().getAmount() > 0) {
            int startX = 97;
            int startY = 93;
            int endX = 133;
            int endY = 124;
            if (mouseX >= this.field_147003_i + startX && mouseX < this.field_147003_i + endX && mouseY >= this.field_147009_r + startY && mouseY < this.field_147009_r + endY) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(I18n.func_135052_a((String)((TECrucible)this.tile).getAlloy().getResult().getTranslationKey(), (Object[])new Object[0]));
                int amount = ((TECrucible)this.tile).getAlloy().getAmount();
                int maxAmount = ((TECrucible)this.tile).getAlloy().getMaxAmount();
                tooltip.add(I18n.func_135052_a((String)"tfc.tooltip.crucible_units", (Object[])new Object[]{amount, maxAmount}));
                this.func_146283_a(tooltip, mouseX, mouseY);
            }
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseX >= this.field_147003_i + 154 && mouseX <= this.field_147003_i + 165 && mouseY >= this.field_147009_r + 11 + this.scrollPos && mouseY <= this.field_147009_r + 26 + this.scrollPos) {
            this.scrollPress = true;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (!Mouse.isButtonDown((int)0)) {
            this.scrollPress = false;
        }
        if (this.scrollPress) {
            this.scrollPos = Math.min(Math.max(mouseY - this.field_147009_r - 18, 0), 49);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int temperature = (int)((float)(51 * ((TECrucible)this.tile).getField(0)) / Heat.maxVisibleTemperature());
        if (temperature > 0) {
            if (temperature > 51) {
                temperature = 51;
            }
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 131 - temperature, 176, 0, 15, 5);
        }
        this.func_73729_b(this.field_147003_i + 154, this.field_147009_r + 11 + this.scrollPos, 176, 7, 12, 15);
        Alloy alloy = ((TECrucible)this.tile).getAlloy();
        if (alloy.getAmount() > 0) {
            int startX = 97;
            int startY = 93;
            int endX = 133;
            int endY = 124;
            int fillHeight = (int)Math.ceil((float)(endY - startY) * (float)alloy.getAmount() / (float)alloy.getMaxAmount());
            Fluid fluid = FluidsTFC.getFluidFromMetal(alloy.getResult());
            TextureAtlasSprite sprite = FluidSpriteCache.getStillSprite(fluid);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            int color = fluid.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            int yPos = endY;
            while (fillHeight > 0) {
                int yPixels = Math.min(fillHeight, 16);
                int fillWidth = endX - startX;
                int xPos = endX;
                while (fillWidth > 0) {
                    int xPixels = Math.min(fillWidth, 16);
                    buffer.func_181662_b((double)(this.field_147003_i + xPos - xPixels), (double)(this.field_147009_r + yPos - yPixels), 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
                    buffer.func_181662_b((double)(this.field_147003_i + xPos - xPixels), (double)(this.field_147009_r + yPos), 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
                    buffer.func_181662_b((double)(this.field_147003_i + xPos), (double)(this.field_147009_r + yPos), 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
                    buffer.func_181662_b((double)(this.field_147003_i + xPos), (double)(this.field_147009_r + yPos - yPixels), 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
                    fillWidth -= 16;
                    xPos -= 16;
                }
                fillHeight -= 16;
                yPos -= 16;
            }
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(CRUCIBLE_BACKGROUND);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Metal result = ((TECrucible)this.tile).getAlloyResult();
            String resultText = TextFormatting.UNDERLINE + I18n.func_135052_a((String)result.getTranslationKey(), (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(resultText, this.field_147003_i + 10, this.field_147009_r + 11, 0);
            int startElement = Math.max(0, (int)Math.floor((double)(alloy.getMetals().size() - 3) / 49.0 * (double)(this.scrollPos + 1)));
            yPos = this.field_147009_r + 22;
            int index = -1;
            for (Map.Entry<Metal, Double> entry : alloy.getMetals().entrySet()) {
                if (++index < startElement) continue;
                if (index > startElement - 1 + 3) break;
                String metalName = this.field_146289_q.func_78269_a(I18n.func_135052_a((String)entry.getKey().getTranslationKey(), (Object[])new Object[0]), 141);
                metalName = metalName + ":";
                String units = entry.getValue() >= 1.0 ? I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{entry.getValue().intValue()}) : I18n.func_135052_a((String)"tfc.tooltip.crucible_less_than_one", (Object[])new Object[0]);
                String content = String.format("  %s(%s%2.1f%%%s)", units, TextFormatting.DARK_GREEN, 100.0 * entry.getValue() / (double)alloy.getAmount(), TextFormatting.RESET);
                this.field_146289_q.func_78276_b(metalName, this.field_147003_i + 10, yPos, 0x404040);
                this.field_146289_q.func_78276_b(content, this.field_147003_i + 10, yPos + 9, 0x404040);
                yPos += 18;
            }
        }
    }
}

