/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.gui;

import java.io.IOException;
import java.util.List;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.client.button.GuiButtonAnvilPlanIcon;
import net.dries007.tfc.client.button.GuiButtonPage;
import net.dries007.tfc.client.button.IButtonTooltip;
import net.dries007.tfc.client.gui.GuiContainerTE;
import net.dries007.tfc.network.PacketGuiButton;
import net.dries007.tfc.objects.te.TEAnvilTFC;
import net.dries007.tfc.util.NBTBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@SideOnly(value=Side.CLIENT)
public class GuiAnvilPlan
extends GuiContainerTE<TEAnvilTFC> {
    public static final ResourceLocation PLAN_BACKGROUND = new ResourceLocation("tfc", "textures/gui/anvil_plan.png");
    private final ItemStack inputStack;
    private int page;
    private GuiButton buttonLeft;
    private GuiButton buttonRight;

    public GuiAnvilPlan(Container container, InventoryPlayer playerInv, TEAnvilTFC tile) {
        super(container, playerInv, tile, PLAN_BACKGROUND);
        IItemHandler cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.inputStack = cap == null ? ItemStack.field_190927_a : cap.getStackInSlot(0);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.page = 0;
        this.updatePage();
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        for (GuiButton button : this.field_146292_n) {
            IButtonTooltip tooltip;
            if (!(button instanceof IButtonTooltip) || !button.func_146115_a() || !(tooltip = (IButtonTooltip)button).hasTooltip()) continue;
            this.func_146279_a(I18n.func_135052_a((String)tooltip.getTooltip(), (Object[])new Object[0]), mouseX, mouseY);
        }
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = I18n.func_135052_a((String)"tfc.tooltip.anvil_plan", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.inputStack.func_77977_a() + ".name"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiButtonAnvilPlanIcon) {
            ResourceLocation recipeName = ((GuiButtonAnvilPlanIcon)button).getRecipeName();
            TerraFirmaCraft.getNetwork().sendToServer((IMessage)new PacketGuiButton(button.field_146127_k, new NBTBuilder().setString("recipe", recipeName.toString()).build()));
        } else if (button == this.buttonLeft) {
            --this.page;
            this.updatePage();
        } else if (button == this.buttonRight) {
            ++this.page;
            this.updatePage();
        }
        super.func_146284_a(button);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void updatePage() {
        this.field_146292_n.clear();
        int buttonID = -1;
        List<AnvilRecipe> recipeList = AnvilRecipe.getAllFor(this.inputStack);
        for (int i = this.page * 18; i < (this.page + 1) * 18 && i < recipeList.size(); ++i) {
            int posX = 7 + i % 9 * 18;
            int posY = 25 + i % 18 / 9 * 18;
            this.func_189646_b(new GuiButtonAnvilPlanIcon(recipeList.get(i), ++buttonID, this.field_147003_i + posX, this.field_147009_r + posY));
        }
        this.buttonLeft = this.func_189646_b(new GuiButtonPage(++buttonID, this.field_147003_i + 7, this.field_147009_r + 65, GuiButtonPage.Type.LEFT, "tfc.tooltip.previous_page"));
        this.buttonRight = this.func_189646_b(new GuiButtonPage(++buttonID, this.field_147003_i + 154, this.field_147009_r + 65, GuiButtonPage.Type.RIGHT, "tfc.tooltip.next_page"));
        if (recipeList.size() <= 18) {
            this.buttonLeft.field_146125_m = false;
            this.buttonRight.field_146125_m = false;
        } else {
            if (this.page <= 0) {
                this.buttonLeft.field_146124_l = false;
            }
            if ((this.page + 1) * 18 >= recipeList.size()) {
                this.buttonRight.field_146124_l = false;
            }
        }
    }
}

