/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.awt.Color;
import java.time.Month;
import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class GrassColorHandler {
    public static NoiseGeneratorPerlin noiseGenerator = new NoiseGeneratorPerlin(new Random("NOISE_GRASS".hashCode()), 2);
    public static Color[] monthlyColors = new Color[12];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetColors() {
        int julyCode = 0;
        int octoberCode = 0;
        int januaryCode = 0;
        int aprilCode = 0;
        try {
            julyCode = Integer.parseUnsignedInt(ConfigTFC.Client.GRASS_COLOR.seasonColorSummer, 16);
            octoberCode = Integer.parseUnsignedInt(ConfigTFC.Client.GRASS_COLOR.seasonColorAutumn, 16);
            januaryCode = Integer.parseUnsignedInt(ConfigTFC.Client.GRASS_COLOR.seasonColorWinter, 16);
            aprilCode = Integer.parseUnsignedInt(ConfigTFC.Client.GRASS_COLOR.seasonColorSpring, 16);
            GrassColorHandler.monthlyColors[Month.JULY.ordinal()] = new Color(julyCode, true);
            GrassColorHandler.monthlyColors[Month.OCTOBER.ordinal()] = new Color(octoberCode, true);
            GrassColorHandler.monthlyColors[Month.JANUARY.ordinal()] = new Color(januaryCode, true);
            GrassColorHandler.monthlyColors[Month.APRIL.ordinal()] = new Color(aprilCode, true);
        }
        catch (Throwable throwable) {
            GrassColorHandler.monthlyColors[Month.JULY.ordinal()] = new Color(julyCode, true);
            GrassColorHandler.monthlyColors[Month.OCTOBER.ordinal()] = new Color(octoberCode, true);
            GrassColorHandler.monthlyColors[Month.JANUARY.ordinal()] = new Color(januaryCode, true);
            GrassColorHandler.monthlyColors[Month.APRIL.ordinal()] = new Color(aprilCode, true);
            for (int i = 0; i < 12; i += 3) {
                GrassColorHandler.monthlyColors[i + 1] = GrassColorHandler.blendWithAlphas(monthlyColors[i], monthlyColors[(i + 3) % 12], 0.7);
                GrassColorHandler.monthlyColors[i + 2] = GrassColorHandler.blendWithAlphas(monthlyColors[i], monthlyColors[(i + 3) % 12], 0.3);
            }
            throw throwable;
        }
        for (int i = 0; i < 12; i += 3) {
            GrassColorHandler.monthlyColors[i + 1] = GrassColorHandler.blendWithAlphas(monthlyColors[i], monthlyColors[(i + 3) % 12], 0.7);
            GrassColorHandler.monthlyColors[i + 2] = GrassColorHandler.blendWithAlphas(monthlyColors[i], monthlyColors[(i + 3) % 12], 0.3);
        }
    }

    public static int computeGrassColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        if (pos != null) {
            Color originalColor = new Color(GrassColorHandler.computeInitialGrassColor(state, worldIn, pos, tintIndex));
            Color seasonalColor = GrassColorHandler.getSeasonalColor();
            Color finalColor = originalColor;
            if (ConfigTFC.Client.GRASS_COLOR.seasonColorEnable) {
                finalColor = GrassColorHandler.blendByAlpha(finalColor, seasonalColor);
            }
            if (ConfigTFC.Client.GRASS_COLOR.noiseEnable) {
                int levels = ConfigTFC.Client.GRASS_COLOR.noiseLevels;
                float scale = ConfigTFC.Client.GRASS_COLOR.noiseScale;
                double darkness = ConfigTFC.Client.GRASS_COLOR.noiseDarkness;
                double value = noiseGenerator.func_151601_a((double)((float)pos.func_177958_n() / scale), (double)((float)pos.func_177952_p() / scale));
                value = GrassColorHandler.curve(0.0, 1.0, GrassColorHandler.remap(value, -((1 << levels) - 1), (1 << levels) - 1, 0.0, 1.0), 1.0) * darkness;
                finalColor = GrassColorHandler.blendByWeight(Color.BLACK, finalColor, value);
            }
            return finalColor.getRGB();
        }
        return ColorizerGrass.func_77480_a((double)0.5, (double)0.5);
    }

    public static Color getSeasonalColor() {
        return monthlyColors[CalendarTFC.CALENDAR_TIME.getMonthOfYear().ordinal()];
    }

    public static double remap(double value, double currentLow, double currentHigh, double newLow, double newHigh) {
        return newLow + (value - currentLow) * (newHigh - newLow) / (currentHigh - currentLow);
    }

    public static double curve(double start, double end, double amount, double waves) {
        amount = MathHelper.func_151237_a((double)amount, (double)0.0, (double)1.0);
        amount = MathHelper.func_151237_a((double)((amount - start) / (end - start)), (double)0.0, (double)1.0);
        return MathHelper.func_151237_a((double)(0.5 + 0.5 * (double)MathHelper.func_76126_a((float)MathHelper.func_76134_b((float)((float)(Math.PI * Math.tan(90.0 * amount))))) * (double)MathHelper.func_76134_b((float)MathHelper.func_76126_a((float)((float)Math.tan(amount))))), (double)0.0, (double)1.0);
    }

    public static Color blendByWeight(Color c0, Color c1, double weight0) {
        double weight1 = 1.0 - weight0;
        double r = weight0 * (double)c0.getRed() + weight1 * (double)c1.getRed();
        double g = weight0 * (double)c0.getGreen() + weight1 * (double)c1.getGreen();
        double b = weight0 * (double)c0.getBlue() + weight1 * (double)c1.getBlue();
        double a = Math.max(c0.getAlpha(), c1.getAlpha());
        return new Color((int)r, (int)g, (int)b, (int)a);
    }

    public static Color blendWithAlphas(Color c0, Color c1, double weight0) {
        double weight1 = 1.0 - weight0;
        double r = weight0 * (double)c0.getRed() + weight1 * (double)c1.getRed();
        double g = weight0 * (double)c0.getGreen() + weight1 * (double)c1.getGreen();
        double b = weight0 * (double)c0.getBlue() + weight1 * (double)c1.getBlue();
        double a = weight0 * (double)c0.getAlpha() + weight1 * (double)c1.getAlpha();
        return new Color((int)r, (int)g, (int)b, (int)a);
    }

    public static Color blendByAlpha(Color c0, Color c1) {
        return GrassColorHandler.blendByWeight(c0, c1, 1.0 - (double)c1.getAlpha() / 255.0);
    }

    private static int computeInitialGrassColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        if (pos != null) {
            double temp = MathHelper.func_76131_a((float)((ClimateTFC.getMonthlyTemp(pos) + 30.0f) / 60.0f), (float)0.0f, (float)1.0f);
            double rain = MathHelper.func_76131_a((float)((ClimateTFC.getRainfall(pos) - 50.0f) / 400.0f), (float)0.0f, (float)1.0f);
            return ColorizerGrass.func_77480_a((double)temp, (double)rain);
        }
        return ColorizerGrass.func_77480_a((double)0.5, (double)0.5);
    }

    static {
        GrassColorHandler.resetColors();
    }
}

