/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.types;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.types.DefaultTrees;
import net.dries007.tfc.util.Helpers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Tree
extends IForgeRegistryEntry.Impl<Tree> {
    @GameRegistry.ObjectHolder(value="tfc:sequoia")
    public static final Tree SEQUOIA = (Tree)((Object)Helpers.getNull());
    private final int maxGrowthRadius;
    private final float dominance;
    private final int maxHeight;
    private final int maxDecayDistance;
    private final boolean isConifer;
    private final ITreeGenerator bushGenerator;
    private final boolean canMakeTannin;
    private final float minGrowthTime;
    private final float minTemp;
    private final float maxTemp;
    private final float minRain;
    private final float maxRain;
    private final float minDensity;
    private final float maxDensity;
    private final float burnTemp;
    private final int burnTicks;
    private ITreeGenerator generator;

    public Tree(@Nonnull ResourceLocation name, @Nonnull ITreeGenerator generator, float minTemp, float maxTemp, float minRain, float maxRain, float minDensity, float maxDensity, float dominance, int maxGrowthRadius, int maxHeight, int maxDecayDistance, boolean isConifer, @Nullable ITreeGenerator bushGenerator, boolean canMakeTannin, float minGrowthTime, float burnTemp, int burnTicks) {
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.minRain = minRain;
        this.maxRain = maxRain;
        this.dominance = dominance;
        this.maxGrowthRadius = maxGrowthRadius;
        this.maxHeight = maxHeight;
        this.maxDecayDistance = maxDecayDistance;
        this.isConifer = isConifer;
        this.minGrowthTime = minGrowthTime;
        this.minDensity = minDensity;
        this.maxDensity = maxDensity;
        this.bushGenerator = bushGenerator;
        this.canMakeTannin = canMakeTannin;
        this.burnTemp = burnTemp;
        this.burnTicks = burnTicks;
        this.generator = generator;
        this.setRegistryName(name);
    }

    public boolean makeTree(TemplateManager manager, World world, BlockPos pos, Random rand, boolean isWorldGen) {
        if (this.generator.canGenerateTree(world, pos, this)) {
            this.generator.generateTree(manager, world, pos, this, rand, isWorldGen);
            return true;
        }
        return false;
    }

    public boolean makeTree(World world, BlockPos pos, Random rand, boolean isWorldGen) {
        if (!world.field_72995_K) {
            return this.makeTree(((WorldServer)world).func_184163_y(), world, pos, rand, isWorldGen);
        }
        return false;
    }

    public boolean isValidLocation(float temp, float rain, float density) {
        return this.minTemp <= temp && this.maxTemp >= temp && this.minRain <= rain && this.maxRain >= rain && this.minDensity <= density && this.maxDensity >= density;
    }

    public void setTreeGenerator(ITreeGenerator generator) {
        this.generator = generator;
    }

    public int getMaxGrowthRadius() {
        return this.maxGrowthRadius;
    }

    public float getDominance() {
        return this.dominance;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxDecayDistance() {
        return this.maxDecayDistance;
    }

    public boolean isConifer() {
        return this.isConifer;
    }

    public boolean canMakeTannin() {
        return this.canMakeTannin;
    }

    public boolean hasBushes() {
        return this.bushGenerator != null;
    }

    @Nullable
    public ITreeGenerator getBushGen() {
        return this.bushGenerator;
    }

    public float getMinGrowthTime() {
        return this.minGrowthTime;
    }

    public float getBurnTemp() {
        return this.burnTemp;
    }

    public int getBurnTicks() {
        return this.burnTicks;
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public static class Builder {
        private final float minTemp;
        private final float maxTemp;
        private final float minRain;
        private final float maxRain;
        private final ITreeGenerator gen;
        private final ResourceLocation name;
        private float minDensity;
        private float maxDensity;
        private float dominance;
        private int maxHeight;
        private int maxGrowthRadius;
        private int maxDecayDistance;
        private boolean isConifer;
        private ITreeGenerator bushGenerator;
        private boolean canMakeTannin;
        private float minGrowthTime;
        private float burnTemp;
        private int burnTicks;

        public Builder(@Nonnull ResourceLocation name, float minRain, float maxRain, float minTemp, float maxTemp, @Nonnull ITreeGenerator gen) {
            this.minTemp = minTemp;
            this.maxTemp = maxTemp;
            this.minRain = minRain;
            this.maxRain = maxRain;
            this.name = name;
            this.gen = gen;
            this.maxGrowthRadius = 1;
            this.dominance = 0.001f * (maxTemp - minTemp) * (maxRain - minRain);
            this.maxHeight = 6;
            this.maxDecayDistance = 4;
            this.isConifer = false;
            this.bushGenerator = null;
            this.canMakeTannin = false;
            this.minGrowthTime = 7.0f;
            this.minDensity = 0.1f;
            this.maxDensity = 2.0f;
            this.burnTemp = 675.0f;
            this.burnTicks = 1500;
        }

        public Builder setRadius(int maxGrowthRadius) {
            this.maxGrowthRadius = maxGrowthRadius;
            return this;
        }

        public Builder setDecayDist(int maxDecayDistance) {
            this.maxDecayDistance = maxDecayDistance;
            return this;
        }

        public Builder setConifer() {
            this.isConifer = true;
            return this;
        }

        public Builder setBushes() {
            this.bushGenerator = DefaultTrees.GEN_BUSHES;
            return this;
        }

        public Builder setBushes(ITreeGenerator bushGenerator) {
            this.bushGenerator = bushGenerator;
            return this;
        }

        public Builder setTannin() {
            this.canMakeTannin = true;
            return this;
        }

        public Builder setHeight(int maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public Builder setGrowthTime(float growthTime) {
            this.minGrowthTime = growthTime;
            return this;
        }

        public Builder setDensity(float min, float max) {
            this.minDensity = min;
            this.maxDensity = max;
            return this;
        }

        public Builder setDominance(float dom) {
            this.dominance = dom;
            return this;
        }

        public Builder setBurnInfo(float burnTemp, int burnTicks) {
            this.burnTemp = burnTemp;
            this.burnTicks = burnTicks;
            return this;
        }

        public Tree build() {
            return new Tree(this.name, this.gen, this.minTemp, this.maxTemp, this.minRain, this.maxRain, this.minDensity, this.maxDensity, this.dominance, this.maxGrowthRadius, this.maxHeight, this.maxDecayDistance, this.isConifer, this.bushGenerator, this.canMakeTannin, this.minGrowthTime, this.burnTemp, this.burnTicks);
        }
    }
}

