/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.types;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.types.Rock;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RockCategory
extends IForgeRegistryEntry.Impl<RockCategory> {
    private final float caveGenMod;
    private final float caveFreqMod;
    private final Item.ToolMaterial toolMaterial;
    private final boolean layer1;
    private final boolean layer2;
    private final boolean layer3;
    private final boolean hasAnvil;
    private final float hardness;
    private final float resistance;

    public RockCategory(@Nonnull ResourceLocation name, @Nonnull Item.ToolMaterial toolMaterial, boolean layer1, boolean layer2, boolean layer3, float caveGenMod, float caveFreqMod, float hardness, float resistance, boolean hasAnvil) {
        this.setRegistryName(name);
        this.toolMaterial = toolMaterial;
        this.caveGenMod = caveGenMod;
        this.caveFreqMod = caveFreqMod;
        this.layer1 = layer1;
        this.layer2 = layer2;
        this.layer3 = layer3;
        this.hasAnvil = hasAnvil;
        this.hardness = hardness;
        this.resistance = resistance;
    }

    @Nonnull
    public Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    public float getCaveGenMod() {
        return this.caveGenMod;
    }

    public float getCaveFreqMod() {
        return this.caveFreqMod;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public boolean hasAnvil() {
        return this.hasAnvil;
    }

    public String getTranslationKey() {
        return "tfc.types.rock_category." + this.getRegistryName().func_110623_a();
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public static enum Layer implements Predicate<Rock>
    {
        BOTTOM(3, x -> RockCategory.access$200(x.getRockCategory())),
        MIDDLE(2, x -> RockCategory.access$100(x.getRockCategory())),
        TOP(1, x -> RockCategory.access$000(x.getRockCategory()));

        public final int layer;
        private final Predicate<Rock> filter;

        private Layer(int layer, Predicate<Rock> filter) {
            this.layer = layer;
            this.filter = filter;
        }

        @Override
        public boolean test(Rock rock) {
            return this.filter.test(rock);
        }
    }
}

