/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.types;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.objects.items.rock.ItemRockAxe;
import net.dries007.tfc.objects.items.rock.ItemRockHammer;
import net.dries007.tfc.objects.items.rock.ItemRockHoe;
import net.dries007.tfc.objects.items.rock.ItemRockJavelin;
import net.dries007.tfc.objects.items.rock.ItemRockKnife;
import net.dries007.tfc.objects.items.rock.ItemRockShovel;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Rock
extends IForgeRegistryEntry.Impl<Rock> {
    @GameRegistry.ObjectHolder(value="tfc:granite")
    public static final Rock GRANITE = (Rock)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:basalt")
    public static final Rock BASALT = (Rock)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:rhyolite")
    public static final Rock RHYOLITE = (Rock)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:limestone")
    public static final Rock LIMESTONE = (Rock)((Object)Helpers.getNull());
    private final RockCategory rockCategory;
    private final ResourceLocation textureLocation;
    private final boolean isFluxStone;

    public Rock(@Nonnull ResourceLocation name, @Nonnull RockCategory rockCategory, boolean isFluxStone) {
        if (rockCategory == null) {
            throw new IllegalArgumentException("Rock category is not allowed to be null (on rock " + name + ")");
        }
        this.setRegistryName(name);
        this.rockCategory = rockCategory;
        this.textureLocation = new ResourceLocation("tfc", "textures/blocks/stonetypes/raw/" + name.func_110623_a() + ".png");
        this.isFluxStone = isFluxStone;
    }

    public Rock(@Nonnull ResourceLocation name, @Nonnull ResourceLocation categoryName, boolean isFluxStone) {
        this(name, (RockCategory)TFCRegistries.ROCK_CATEGORIES.getValue(categoryName), isFluxStone);
    }

    public ResourceLocation getTexture() {
        return this.textureLocation;
    }

    public RockCategory getRockCategory() {
        return this.rockCategory;
    }

    public boolean isFluxStone() {
        return this.isFluxStone;
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public static enum FallingBlockType {
        NO_FALL,
        FALL_VERTICAL,
        FALL_HORIZONTAL;

    }

    public static enum Type {
        RAW(Material.field_151576_e, FallingBlockType.FALL_VERTICAL, false),
        ANVIL(Material.field_151576_e, FallingBlockType.FALL_VERTICAL, false),
        SPIKE(Material.field_151576_e, FallingBlockType.NO_FALL, false),
        SMOOTH(Material.field_151576_e, FallingBlockType.FALL_VERTICAL, false),
        COBBLE(Material.field_151576_e, FallingBlockType.FALL_HORIZONTAL, false),
        BRICKS(Material.field_151576_e, FallingBlockType.NO_FALL, false),
        SAND(Material.field_151595_p, FallingBlockType.FALL_HORIZONTAL, false),
        GRAVEL(Material.field_151595_p, FallingBlockType.FALL_HORIZONTAL, false),
        DIRT(Material.field_151578_c, FallingBlockType.FALL_HORIZONTAL, false),
        GRASS(Material.field_151577_b, FallingBlockType.FALL_HORIZONTAL, true),
        DRY_GRASS(Material.field_151577_b, FallingBlockType.FALL_HORIZONTAL, true),
        CLAY(Material.field_151571_B, FallingBlockType.FALL_VERTICAL, false),
        CLAY_GRASS(Material.field_151577_b, FallingBlockType.FALL_VERTICAL, true),
        FARMLAND(Material.field_151578_c, FallingBlockType.FALL_VERTICAL, false),
        PATH(Material.field_151578_c, FallingBlockType.FALL_VERTICAL, false);

        public final Material material;
        public final boolean isGrass;
        private final FallingBlockType gravType;

        private Type(Material material, FallingBlockType gravType, boolean isGrass) {
            this.material = material;
            this.gravType = gravType;
            this.isGrass = isGrass;
        }

        public boolean canFall() {
            return this.gravType != FallingBlockType.NO_FALL;
        }

        public boolean canFallHorizontal() {
            return this.gravType == FallingBlockType.FALL_HORIZONTAL;
        }

        public Type getNonGrassVersion() {
            if (!this.isGrass) {
                return this;
            }
            switch (this) {
                case GRASS: {
                    return DIRT;
                }
                case DRY_GRASS: {
                    return DIRT;
                }
                case CLAY_GRASS: {
                    return CLAY;
                }
            }
            throw new IllegalStateException("Someone forgot to add enum constants to this switch case...");
        }

        public Type getGrassVersion(Type spreader) {
            if (!spreader.isGrass) {
                throw new IllegalArgumentException("Non-grass can't spread.");
            }
            switch (this) {
                case DIRT: {
                    return spreader == DRY_GRASS ? DRY_GRASS : GRASS;
                }
                case CLAY: {
                    return CLAY_GRASS;
                }
            }
            throw new IllegalArgumentException("You cannot get grass from rock types.");
        }
    }

    public static enum ToolType {
        AXE(ItemRockAxe::new, " X   ", "XXXX ", "XXXXX", "XXXX ", " X   "),
        SHOVEL(ItemRockShovel::new, "XXX", "XXX", "XXX", "XXX", " X "),
        HOE(ItemRockHoe::new, "XXXXX", "   XX"),
        KNIFE(ItemRockKnife::new, "X ", "XX", "XX", "XX", "XX"),
        JAVELIN(ItemRockJavelin::new, "XXX  ", "XXXX ", "XXXXX", " XXX ", "  X  "),
        HAMMER(ItemRockHammer::new, "XXXXX", "XXXXX", "  X  ");

        private final Function<RockCategory, Item> supplier;
        private final String[] pattern;

        private ToolType(Function<RockCategory, Item> supplier, String ... pattern) {
            this.supplier = supplier;
            this.pattern = pattern;
        }

        public Item create(RockCategory category) {
            return this.supplier.apply(category);
        }

        public String[] getPattern() {
            return this.pattern;
        }
    }
}

