/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.types;

import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.types.IPlantType;
import net.dries007.tfc.objects.blocks.plants.BlockCactusTFC;
import net.dries007.tfc.objects.blocks.plants.BlockCreepingPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockEmergentTallWaterPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockEpiphyteTFC;
import net.dries007.tfc.objects.blocks.plants.BlockFloatingWaterTFC;
import net.dries007.tfc.objects.blocks.plants.BlockHangingPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockMushroomTFC;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockShortGrassTFC;
import net.dries007.tfc.objects.blocks.plants.BlockTallGrassTFC;
import net.dries007.tfc.objects.blocks.plants.BlockTallPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockTallWaterPlantTFC;
import net.dries007.tfc.objects.blocks.plants.BlockWaterPlantTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Plant
extends IForgeRegistryEntry.Impl<Plant> {
    private final int[] stages;
    private final int numStages;
    private final float minGrowthTemp;
    private final float maxGrowthTemp;
    private final float minTemp;
    private final float maxTemp;
    private final float minRain;
    private final float maxRain;
    private final int minSun;
    private final int maxSun;
    private final int maxHeight;
    private final int minWaterDepth;
    private final int maxWaterDepth;
    private final double movementMod;
    private final PlantType plantType;
    private final Material material;
    private final boolean isClayMarking;
    private final boolean isSwampPlant;
    private final Optional<String> oreDictName;

    public Plant(@Nonnull ResourceLocation name, PlantType plantType, int[] stages, boolean isClayMarking, boolean isSwampPlant, float minGrowthTemp, float maxGrowthTemp, float minTemp, float maxTemp, float minRain, float maxRain, int minSun, int maxSun, int maxHeight, int minWaterDepth, int maxWaterDepth, double movementMod, String oreDictName) {
        this.stages = stages;
        this.minGrowthTemp = minGrowthTemp;
        this.maxGrowthTemp = maxGrowthTemp;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.minRain = minRain;
        this.maxRain = maxRain;
        this.minSun = minSun;
        this.maxSun = maxSun;
        this.maxHeight = maxHeight;
        this.minWaterDepth = minWaterDepth;
        this.maxWaterDepth = maxWaterDepth;
        this.movementMod = movementMod;
        this.plantType = plantType;
        this.isClayMarking = isClayMarking;
        this.isSwampPlant = isSwampPlant;
        this.material = plantType.getPlantMaterial();
        this.oreDictName = Optional.ofNullable(oreDictName);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int stage : stages) {
            hashSet.add(stage);
        }
        this.numStages = hashSet.size() <= 1 ? 1 : hashSet.size() - 1;
        this.setRegistryName(name);
    }

    public Plant(@Nonnull ResourceLocation name, PlantType plantType, int[] stages, boolean isClayMarking, boolean isSwampPlant, float minGrowthTemp, float maxGrowthTemp, float minTemp, float maxTemp, float minRain, float maxRain, int minSun, int maxSun, int maxHeight, double movementMod, String oreDictName) {
        this(name, plantType, stages, isClayMarking, isSwampPlant, minGrowthTemp, maxGrowthTemp, minTemp, maxTemp, minRain, maxRain, minSun, maxSun, maxHeight, 0, 0, movementMod, oreDictName);
    }

    public double getMovementMod() {
        return this.movementMod;
    }

    public boolean getIsClayMarking() {
        return this.isClayMarking;
    }

    public boolean getIsSwampPlant() {
        return this.isSwampPlant;
    }

    public boolean isValidLocation(float temp, float rain, int sunlight) {
        return this.isValidTemp(temp) && this.isValidRain(rain) && this.isValidSunlight(sunlight);
    }

    public boolean isValidTemp(float temp) {
        return this.getTempValidity(temp) == PlantValidity.VALID;
    }

    public boolean isValidTempForWorldGen(float temp) {
        return Math.abs(temp - this.getAvgTemp()) < Float.sum(this.maxTemp, -this.minTemp) / 4.0f;
    }

    public boolean isValidRain(float rain) {
        return this.getRainValidity(rain) == PlantValidity.VALID;
    }

    public boolean isValidSunlight(int sunlight) {
        return this.minSun <= sunlight && this.maxSun >= sunlight;
    }

    public boolean isValidFloatingWaterDepth(World world, BlockPos pos, IBlockState water) {
        int depthCounter = this.minWaterDepth;
        int maxDepth = this.maxWaterDepth;
        for (int i = 1; i <= depthCounter; ++i) {
            if (world.func_180495_p(pos.func_177979_c(i)) == water || world.func_180495_p(pos.func_177979_c(i)).func_185904_a() == Material.field_151589_v) continue;
            return false;
        }
        while (world.func_180495_p(pos.func_177979_c(depthCounter)) == water || world.func_180495_p(pos.func_177979_c(depthCounter)).func_185904_a() == Material.field_151589_v) {
            ++depthCounter;
        }
        return maxDepth > 0 && depthCounter <= maxDepth + 1;
    }

    public int getValidWaterDepth(World world, BlockPos pos, IBlockState water) {
        int depthCounter = this.minWaterDepth;
        int maxDepth = this.maxWaterDepth;
        if (depthCounter == 0 || maxDepth == 0) {
            return -1;
        }
        for (int i = 1; i <= depthCounter; ++i) {
            if (world.func_180495_p(pos.func_177979_c(i)) == water) continue;
            return -1;
        }
        while (world.func_180495_p(pos.func_177979_c(depthCounter)) == water) {
            if (++depthCounter <= maxDepth + 1) continue;
            return -1;
        }
        return depthCounter;
    }

    public float getMinGrowthTemp() {
        return this.minGrowthTemp;
    }

    public float getMaxGrowthTemp() {
        return this.maxGrowthTemp;
    }

    public int getStageForMonth(Month month) {
        return this.stages[month.ordinal()];
    }

    public int getStageForMonth() {
        return this.getStageForMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear());
    }

    public int getNumStages() {
        return this.numStages;
    }

    public boolean isValidGrowthTemp(float temp) {
        return this.minGrowthTemp <= temp && this.maxGrowthTemp >= temp;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public Optional<String> getOreDictName() {
        return this.oreDictName;
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    @Nonnull
    public PlantType getPlantType() {
        return this.plantType;
    }

    @Nonnull
    public Material getMaterial() {
        return this.material;
    }

    public IBlockState getWaterType() {
        if (this.plantType == PlantType.FLOATING_SEA || this.plantType == PlantType.WATER_SEA || this.plantType == PlantType.TALL_WATER_SEA || this.plantType == PlantType.EMERGENT_TALL_WATER_SEA) {
            return ChunkGenTFC.SALT_WATER;
        }
        return ChunkGenTFC.FRESH_WATER;
    }

    public int getAgeForWorldgen(Random rand, float temp) {
        return rand.nextInt(Math.max(1, Math.min(Math.round(2.5f + (temp - this.minGrowthTemp) / this.minGrowthTemp), 4)));
    }

    public final EnumPlantTypeTFC getEnumPlantTypeTFC() {
        switch (this.plantType) {
            case DESERT: 
            case DESERT_TALL_PLANT: {
                if (this.isClayMarking) {
                    return EnumPlantTypeTFC.DESERT_CLAY;
                }
                return EnumPlantTypeTFC.NONE;
            }
            case DRY: 
            case DRY_TALL_PLANT: {
                if (this.isClayMarking) {
                    return EnumPlantTypeTFC.DRY_CLAY;
                }
                return EnumPlantTypeTFC.DRY;
            }
            case REED: 
            case TALL_REED: {
                return EnumPlantTypeTFC.FRESH_BEACH;
            }
            case REED_SEA: 
            case TALL_REED_SEA: {
                return EnumPlantTypeTFC.SALT_BEACH;
            }
            case WATER: 
            case TALL_WATER: 
            case EMERGENT_TALL_WATER: {
                return EnumPlantTypeTFC.FRESH_WATER;
            }
            case WATER_SEA: 
            case TALL_WATER_SEA: 
            case EMERGENT_TALL_WATER_SEA: {
                return EnumPlantTypeTFC.SALT_WATER;
            }
        }
        if (this.isClayMarking) {
            return EnumPlantTypeTFC.CLAY;
        }
        return EnumPlantTypeTFC.NONE;
    }

    public PlantValidity getTempValidity(float temp) {
        if (temp < this.minTemp) {
            return PlantValidity.COLD;
        }
        if (temp > this.maxTemp) {
            return PlantValidity.HOT;
        }
        return PlantValidity.VALID;
    }

    public PlantValidity getRainValidity(float rain) {
        if (rain < this.minRain) {
            return PlantValidity.DRY;
        }
        if (rain > this.maxRain) {
            return PlantValidity.WET;
        }
        return PlantValidity.VALID;
    }

    private float getAvgTemp() {
        return Float.sum(this.minTemp, this.maxTemp) / 2.0f;
    }

    public static enum EnumPlantTypeTFC {
        CLAY,
        DESERT_CLAY,
        DRY_CLAY,
        DRY,
        FRESH_BEACH,
        SALT_BEACH,
        FRESH_WATER,
        SALT_WATER,
        NONE;


        public String toString() {
            return this.name();
        }
    }

    public static enum PlantType implements IPlantType
    {
        STANDARD(BlockPlantTFC::new),
        TALL_PLANT(BlockTallPlantTFC::new),
        CREEPING(BlockCreepingPlantTFC::new),
        HANGING(BlockHangingPlantTFC::new),
        FLOATING(BlockFloatingWaterTFC::new),
        FLOATING_SEA(BlockFloatingWaterTFC::new),
        DESERT(BlockPlantTFC::new),
        DESERT_TALL_PLANT(BlockTallPlantTFC::new),
        DRY(BlockPlantTFC::new),
        DRY_TALL_PLANT(BlockTallPlantTFC::new),
        CACTUS(BlockCactusTFC::new),
        SHORT_GRASS(BlockShortGrassTFC::new),
        TALL_GRASS(BlockTallGrassTFC::new),
        EPIPHYTE(BlockEpiphyteTFC::new),
        REED(BlockPlantTFC::new),
        REED_SEA(BlockPlantTFC::new),
        TALL_REED(BlockTallPlantTFC::new),
        TALL_REED_SEA(BlockTallPlantTFC::new),
        WATER(BlockWaterPlantTFC::new),
        WATER_SEA(BlockWaterPlantTFC::new),
        TALL_WATER(BlockTallWaterPlantTFC::new),
        TALL_WATER_SEA(BlockTallWaterPlantTFC::new),
        EMERGENT_TALL_WATER(BlockEmergentTallWaterPlantTFC::new),
        EMERGENT_TALL_WATER_SEA(BlockEmergentTallWaterPlantTFC::new),
        MUSHROOM(BlockMushroomTFC::new);

        private final Function<Plant, BlockPlantTFC> supplier;

        private PlantType(Function<Plant, BlockPlantTFC> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BlockPlantTFC create(Plant plant) {
            return this.supplier.apply(plant);
        }

        @Override
        public Material getPlantMaterial() {
            switch (this) {
                case CACTUS: {
                    return Material.field_151570_A;
                }
                case HANGING: 
                case SHORT_GRASS: 
                case TALL_GRASS: {
                    return Material.field_151582_l;
                }
                case WATER: 
                case TALL_WATER: 
                case EMERGENT_TALL_WATER: 
                case WATER_SEA: 
                case TALL_WATER_SEA: 
                case EMERGENT_TALL_WATER_SEA: {
                    return Material.field_151589_v;
                }
            }
            return Material.field_151585_k;
        }
    }

    public static enum PlantValidity {
        COLD,
        HOT,
        DRY,
        WET,
        VALID;

    }
}

