/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.types;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="tfc")
public class Ore
extends IForgeRegistryEntry.Impl<Ore> {
    public static final Ore LIMONITE = (Ore)((Object)Helpers.getNull());
    public static final Ore MALACHITE = (Ore)((Object)Helpers.getNull());
    public static final Ore HEMATITE = (Ore)((Object)Helpers.getNull());
    private final boolean graded;
    private final Metal metal;
    private final boolean canMelt;
    private final double chunkChance;
    private final double panChance;

    public Ore(ResourceLocation name, @Nullable Metal metal, boolean canMelt, double chunkChance, double panChance) {
        this.graded = metal != null;
        this.metal = metal;
        this.canMelt = canMelt;
        this.chunkChance = chunkChance;
        this.panChance = panChance;
        this.setRegistryName(name);
    }

    public Ore(ResourceLocation name, @Nonnull ResourceLocation metal, boolean canMelt, double chunkChance, double panChance) {
        this(name, (Metal)TFCRegistries.METALS.getValue(metal), canMelt, chunkChance, panChance);
    }

    public Ore(ResourceLocation name, @Nonnull ResourceLocation metal) {
        this(name, (Metal)TFCRegistries.METALS.getValue(metal), true, 0.0, 0.0);
    }

    public Ore(ResourceLocation name, @Nonnull ResourceLocation metal, boolean canMelt) {
        this(name, (Metal)TFCRegistries.METALS.getValue(metal), canMelt, 0.0, 0.0);
    }

    public Ore(ResourceLocation name, @Nonnull ResourceLocation metal, double chunkChance, double panChance) {
        this(name, (Metal)TFCRegistries.METALS.getValue(metal), true, chunkChance, panChance);
    }

    public Ore(ResourceLocation name) {
        this(name, (Metal)null, false, 0.0, 0.0);
    }

    public boolean isGraded() {
        return this.graded;
    }

    public boolean canPan() {
        return this.chunkChance > 0.0;
    }

    public double getPanChance() {
        return this.panChance;
    }

    public double getChunkChance() {
        return this.chunkChance;
    }

    @Nullable
    public Metal getMetal() {
        return this.metal;
    }

    public boolean canMelt() {
        return this.canMelt;
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public static enum Grade implements IStringSerializable
    {
        NORMAL,
        POOR,
        RICH;

        private static final Grade[] VALUES;

        @Nonnull
        public static Grade valueOf(int value) {
            return value < 0 || value >= VALUES.length ? NORMAL : VALUES[value];
        }

        public int getSmeltAmount() {
            switch (this) {
                case POOR: {
                    return ConfigTFC.General.MISC.poorOreMetalAmount;
                }
                case RICH: {
                    return ConfigTFC.General.MISC.richOreMetalAmount;
                }
            }
            return ConfigTFC.General.MISC.normalOreMetalAmount;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.ordinal();
        }

        static {
            VALUES = Grade.values();
        }
    }
}

