/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.heat;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.metal.CapabilityMetalItem;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class HeatRecipeMetalMelting
extends HeatRecipe {
    private final Metal metal;

    public HeatRecipeMetalMelting(Metal metal) {
        super(input -> {
            IMetalItem metalObject = CapabilityMetalItem.getMetalItem(input);
            if (metalObject != null) {
                return metalObject.getMetal((ItemStack)input) == metal;
            }
            return false;
        }, metal.getMeltTemp(), metal.getTier());
        this.metal = metal;
    }

    @Override
    @Nullable
    public FluidStack getOutputFluid(ItemStack input) {
        Metal metal;
        IMetalItem metalObject = CapabilityMetalItem.getMetalItem(input);
        if (metalObject != null && (metal = metalObject.getMetal(input)) != null) {
            if (metalObject.canMelt(input)) {
                return new FluidStack(FluidsTFC.getFluidFromMetal(metal), metalObject.getSmeltAmount(input));
            }
            return new FluidStack(FluidsTFC.getFluidFromMetal(Metal.UNKNOWN), metalObject.getSmeltAmount(input));
        }
        return null;
    }

    public Metal getMetal() {
        return this.metal;
    }
}

