/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.barrel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.inventory.ingredient.IngredientItemFoodTrait;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BarrelRecipeFoodTraits
extends BarrelRecipe {
    private final FoodTrait trait;
    private final String tooltipName;

    public static BarrelRecipe pickling(@Nonnull IIngredient<ItemStack> inputStack) {
        return new BarrelRecipeFoodTraits(IIngredient.of(FluidsTFC.VINEGAR.get(), 125), (IIngredient<ItemStack>)new IngredientItemFoodTrait(inputStack, FoodTrait.BRINED), FoodTrait.PICKLED, 4000, "barrel_recipe_pickling");
    }

    public static BarrelRecipe brining(@Nonnull IIngredient<ItemStack> inputStack) {
        return new BarrelRecipeFoodTraits(IIngredient.of(FluidsTFC.BRINE.get(), 125), inputStack, FoodTrait.BRINED, 4000, "barrel_recipe_brining");
    }

    private BarrelRecipeFoodTraits(@Nonnull IIngredient<FluidStack> inputFluid, @Nonnull IIngredient<ItemStack> inputStack, FoodTrait trait, int duration, String tooltipName) {
        super(inputFluid, inputStack, null, ItemStack.field_190927_a, duration);
        this.trait = trait;
        this.tooltipName = tooltipName;
    }

    @Override
    public boolean isValidInput(@Nullable FluidStack inputFluid, ItemStack inputStack) {
        IFood food = (IFood)inputStack.getCapability(CapabilityFood.CAPABILITY, null);
        return super.isValidInput(inputFluid, inputStack) && food != null && !food.getTraits().contains(this.trait);
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputItem(FluidStack inputFluid, ItemStack inputStack) {
        ItemStack stack = inputStack.func_77946_l();
        IFood food = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        if (food != null) {
            CapabilityFood.applyTrait(food, this.trait);
        }
        return Helpers.listOf(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getResultName() {
        return I18n.func_135052_a((String)("tfc.tooltip." + this.tooltipName), (Object[])new Object[0]);
    }
}

