/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.barrel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.food.ItemDynamicBowlFood;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class BarrelRecipeDynamicBowlFood
extends BarrelRecipe {
    public BarrelRecipeDynamicBowlFood(IIngredient<FluidStack> inputFluid, IIngredient<ItemStack> inputStack, int duration) {
        super(inputFluid, inputStack, null, new ItemStack(Items.field_151054_z), duration);
    }

    @Override
    public boolean isValidInputInstant(ItemStack inputStack, @Nullable FluidStack inputFluid) {
        return true;
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputItem(FluidStack inputFluid, ItemStack inputStack) {
        int multiplier = this.getMultiplier(inputFluid, inputStack);
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        IFood food = (IFood)inputStack.getCapability(CapabilityFood.CAPABILITY, null);
        ItemStack outputStack = ItemStack.field_190927_a;
        if (food instanceof ItemDynamicBowlFood.DynamicFoodHandler) {
            outputStack = ((ItemDynamicBowlFood.DynamicFoodHandler)food).getBowlStack();
        }
        if (!outputStack.func_190926_b()) {
            int count;
            int expectedOutputCount;
            int outputCount = expectedOutputCount = multiplier * outputStack.func_190916_E();
            do {
                count = Math.min(outputCount, outputStack.func_77976_d());
                ItemStack output = outputStack.func_77946_l();
                output.func_190920_e(count);
                outputList.add(output);
            } while ((outputCount -= count) > 0);
            if (inputStack.func_190916_E() > expectedOutputCount) {
                ItemStack extraInput = inputStack.func_77946_l();
                extraInput.func_190920_e(inputStack.func_190916_E() - outputCount);
                outputList.add(extraInput);
            }
        } else {
            int retainCount = inputStack.func_190916_E() - multiplier * this.inputStack.getAmount();
            if (retainCount > 0) {
                inputStack.func_190920_e(retainCount);
                outputList.add(inputStack);
            } else {
                outputList.add(ItemStack.field_190927_a);
            }
        }
        return outputList;
    }
}

