/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.anvil;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.forge.IForgeableMeasurableMetal;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipeMeasurable;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.forge.ForgeRule;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class AnvilRecipeSplitting
extends AnvilRecipeMeasurable {
    protected int splitAmount;

    public AnvilRecipeSplitting(ResourceLocation name, IIngredient<ItemStack> input, ItemStack icon, int splitAmount, Metal.Tier minTier, ForgeRule ... rules) throws IllegalArgumentException {
        super(name, input, icon, minTier, rules);
        this.splitAmount = splitAmount;
    }

    @Override
    public boolean matches(ItemStack input) {
        if (!super.matches(input)) {
            return false;
        }
        IForgeable cap = (IForgeable)input.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap instanceof IForgeableMeasurableMetal) {
            return this.splitAmount < ((IForgeableMeasurableMetal)cap).getMetalAmount();
        }
        return false;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getOutput(ItemStack input) {
        IForgeable inCap;
        if (this.matches(input) && (inCap = (IForgeable)input.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null)) instanceof IForgeableMeasurableMetal) {
            int metalAmount = ((IForgeableMeasurableMetal)inCap).getMetalAmount();
            Metal metal = ((IForgeableMeasurableMetal)inCap).getMetal();
            int surplus = metalAmount % this.splitAmount;
            int outCount = metalAmount / this.splitAmount;
            NonNullList output = NonNullList.func_191196_a();
            for (int i = 0; i < outCount; ++i) {
                ItemStack dump = input.func_77946_l();
                IForgeable cap = (IForgeable)dump.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
                if (cap instanceof IForgeableMeasurableMetal) {
                    cap.reset();
                    ((IForgeableMeasurableMetal)cap).setMetalAmount(this.splitAmount);
                    ((IForgeableMeasurableMetal)cap).setMetal(metal);
                }
                output.add((Object)dump);
            }
            if (surplus > 0) {
                ItemStack dumpSurplus = input.func_77946_l();
                IForgeable cap = (IForgeable)dumpSurplus.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
                if (cap instanceof IForgeableMeasurableMetal) {
                    cap.reset();
                    ((IForgeableMeasurableMetal)cap).setMetalAmount(surplus);
                    ((IForgeableMeasurableMetal)cap).setMetal(metal);
                }
                output.add((Object)dumpSurplus);
            }
            return output;
        }
        return EMPTY;
    }
}

