/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.anvil;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.jei.IJEISimpleRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.forge.ForgeRule;
import net.dries007.tfc.util.forge.ForgeSteps;
import net.dries007.tfc.util.skills.SmithingSkill;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class AnvilRecipe
extends IForgeRegistryEntry.Impl<AnvilRecipe>
implements IJEISimpleRecipe {
    public static final NonNullList<ItemStack> EMPTY = NonNullList.func_191196_a();
    private static final Random RNG = new Random();
    private static long SEED = 0L;
    protected final ForgeRule[] rules;
    protected final ItemStack output;
    protected final IIngredient<ItemStack> ingredient;
    protected final Metal.Tier minTier;
    protected final long workingSeed;
    protected final SmithingSkill.Type skillBonusType;

    @Nonnull
    public static List<AnvilRecipe> getAllFor(ItemStack stack) {
        return TFCRegistries.ANVIL.getValuesCollection().stream().filter(x -> x.matches(stack)).collect(Collectors.toList());
    }

    public AnvilRecipe(ResourceLocation name, IIngredient<ItemStack> ingredient, ItemStack output, Metal.Tier minTier, @Nullable SmithingSkill.Type skillBonusType, ForgeRule ... rules) {
        this.ingredient = ingredient;
        this.output = output;
        this.minTier = minTier;
        this.skillBonusType = skillBonusType;
        this.rules = rules;
        if (rules.length == 0 || rules.length > 3) {
            throw new IllegalArgumentException("Rules length must be within the closed interval [1, 3]");
        }
        this.setRegistryName(name);
        this.workingSeed = ++SEED;
    }

    public boolean matches(ItemStack input) {
        return this.ingredient.test(input);
    }

    public boolean matches(ForgeSteps steps) {
        for (ForgeRule rule : this.rules) {
            if (rule.matches(steps)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public NonNullList<ItemStack> getOutput(ItemStack input) {
        return this.matches(input) ? NonNullList.func_191197_a((int)1, (Object)this.output.func_77946_l()) : EMPTY;
    }

    @Nonnull
    public ItemStack getPlanIcon() {
        return this.output;
    }

    @Nonnull
    public ForgeRule[] getRules() {
        return this.rules;
    }

    @Nonnull
    public Metal.Tier getTier() {
        return this.minTier;
    }

    @Nullable
    public SmithingSkill.Type getSkillBonusType() {
        return this.skillBonusType;
    }

    public int getTarget(long worldSeed) {
        RNG.setSeed(worldSeed + this.workingSeed);
        return 40 + RNG.nextInt(65);
    }

    @Override
    public NonNullList<IIngredient<ItemStack>> getIngredients() {
        NonNullList list = NonNullList.func_191196_a();
        list.add(this.ingredient);
        list.add(IIngredient.of("hammer"));
        return list;
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return NonNullList.func_191197_a((int)1, (Object)this.output);
    }
}

