/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.jei.IJEISimpleRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.skills.SkillType;
import net.dries007.tfc.util.skills.SmithingSkill;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class WeldingRecipe
extends IForgeRegistryEntry.Impl<WeldingRecipe>
implements IJEISimpleRecipe {
    private final Metal.Tier minTier;
    private final IIngredient<ItemStack> input1;
    private final IIngredient<ItemStack> input2;
    private final ItemStack output;
    private final SmithingSkill.Type skillType;

    public static WeldingRecipe get(ItemStack stack1, ItemStack stack2, Metal.Tier tier) {
        return TFCRegistries.WELDING.getValuesCollection().stream().filter(x -> x.matches(stack1, stack2, tier)).findFirst().orElse(null);
    }

    public WeldingRecipe(ResourceLocation name, IIngredient<ItemStack> input1, IIngredient<ItemStack> input2, ItemStack output, Metal.Tier minTier) {
        this(name, input1, input2, output, minTier, null);
    }

    public WeldingRecipe(ResourceLocation name, IIngredient<ItemStack> input1, IIngredient<ItemStack> input2, ItemStack output, Metal.Tier minTier, @Nullable SmithingSkill.Type skillType) {
        this.input1 = input1;
        this.input2 = input2;
        this.output = output;
        this.minTier = minTier;
        this.skillType = skillType;
        this.setRegistryName(name);
    }

    @Nonnull
    public Metal.Tier getTier() {
        return this.minTier;
    }

    @Nonnull
    public ItemStack getOutput(@Nullable EntityPlayer player) {
        SmithingSkill skill;
        IPlayerData cap;
        ItemStack stack = this.output.func_77946_l();
        if (player != null && (cap = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null)) != null && (skill = cap.getSkill(SkillType.SMITHING)) != null && this.skillType != null) {
            skill.addSkill(this.skillType, 1);
            SmithingSkill.applySkillBonus(skill, stack, this.skillType);
        }
        return stack;
    }

    public boolean matches(ItemStack input1, ItemStack input2, Metal.Tier tier) {
        return tier.isAtLeast(this.minTier) && (this.input1.test(input1) && this.input2.test(input2) || this.input1.test(input2) && this.input2.test(input1));
    }

    @Override
    public NonNullList<IIngredient<ItemStack>> getIngredients() {
        NonNullList list = NonNullList.func_191196_a();
        list.add(this.input1);
        list.add(this.input2);
        list.add(IIngredient.of("dustFlux"));
        return list;
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return NonNullList.func_191197_a((int)1, (Object)this.output);
    }
}

