/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.forge.IForgeableMeasurableMetal;
import net.dries007.tfc.api.capability.metal.CapabilityMetalItem;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BloomeryRecipe
extends IForgeRegistryEntry.Impl<BloomeryRecipe> {
    private final Metal metal;
    private final IIngredient<ItemStack> additive;

    @Nullable
    public static BloomeryRecipe get(@Nonnull ItemStack inputItem) {
        return TFCRegistries.BLOOMERY.getValuesCollection().stream().filter(x -> x.isValidInput(inputItem)).findFirst().orElse(null);
    }

    @Nullable
    public static BloomeryRecipe get(@Nonnull Metal metal) {
        return TFCRegistries.BLOOMERY.getValuesCollection().stream().filter(x -> metal == x.metal).findFirst().orElse(null);
    }

    public BloomeryRecipe(@Nonnull Metal metal, IIngredient<ItemStack> additive) {
        this.metal = metal;
        this.additive = additive;
        this.setRegistryName(metal.getRegistryName());
    }

    public ItemStack getOutput(List<ItemStack> inputs) {
        int metalAmount = 0;
        for (ItemStack stack : inputs) {
            IMetalItem metalItem = CapabilityMetalItem.getMetalItem(stack);
            if (metalItem == null) continue;
            metalAmount += metalItem.getSmeltAmount(stack);
        }
        ItemStack bloom = new ItemStack((Item)ItemsTFC.UNREFINED_BLOOM);
        IForgeable cap = (IForgeable)bloom.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap instanceof IForgeableMeasurableMetal) {
            IForgeableMeasurableMetal capBloom = (IForgeableMeasurableMetal)cap;
            capBloom.setMetalAmount(metalAmount);
            capBloom.setMetal(this.metal);
            capBloom.setTemperature(capBloom.getMeltTemp() - 1.0f);
        }
        return bloom;
    }

    public ItemStack getOutput() {
        ItemStack bloom = new ItemStack((Item)ItemsTFC.UNREFINED_BLOOM);
        IForgeable cap = (IForgeable)bloom.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap instanceof IForgeableMeasurableMetal) {
            IForgeableMeasurableMetal capBloom = (IForgeableMeasurableMetal)cap;
            capBloom.setMetalAmount(100);
            capBloom.setMetal(this.metal);
            capBloom.setTemperature(capBloom.getMeltTemp() - 1.0f);
        }
        return bloom;
    }

    public boolean isValidInput(ItemStack inputItem) {
        IMetalItem metalItem = CapabilityMetalItem.getMetalItem(inputItem);
        return metalItem != null && metalItem.getMetal(inputItem) == this.metal;
    }

    public boolean isValidAdditive(ItemStack input) {
        return this.additive.testIgnoreCount(input);
    }
}

