/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AlloyRecipe
extends IForgeRegistryEntry.Impl<AlloyRecipe> {
    private final ImmutableMap<Metal, DoubleRange> metalMap;
    private final Metal result;

    private AlloyRecipe(@Nonnull Metal result, ImmutableMap<Metal, DoubleRange> alloyMap) {
        this.metalMap = alloyMap;
        this.result = result;
        this.setRegistryName(result.getRegistryName());
    }

    public Metal getResult() {
        return this.result;
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public ImmutableMap<Metal, DoubleRange> getMetals() {
        return this.metalMap;
    }

    public static final class DoubleRange {
        private final double min;
        private final double max;

        DoubleRange(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public boolean test(double value) {
            return value >= this.min - 1.0E-5 && value <= this.max + 1.0E-5;
        }
    }

    public static class Builder {
        private final Metal result;
        private final ImmutableMap.Builder<Metal, DoubleRange> builder;

        public Builder(@Nonnull Metal result) {
            this.result = result;
            this.builder = new ImmutableMap.Builder();
        }

        public Builder(@Nonnull ResourceLocation loc) {
            this.result = (Metal)TFCRegistries.METALS.getValue(loc);
            if (this.result == null) {
                throw new IllegalArgumentException("Result metal is not allowed to be null. Missing metal for key: " + loc.toString());
            }
            this.builder = new ImmutableMap.Builder();
        }

        public Builder add(@Nonnull ResourceLocation loc, double min, double max) {
            return this.add(loc, new DoubleRange(min, max));
        }

        public Builder add(@Nonnull ResourceLocation loc, @Nonnull DoubleRange condition) {
            Metal metal = (Metal)TFCRegistries.METALS.getValue(loc);
            if (metal == null) {
                throw new IllegalArgumentException("Result metal is not allowed to be null. Missing metal for key: " + loc.toString());
            }
            return this.add(metal, condition);
        }

        public Builder add(@Nonnull Metal metal, double min, double max) {
            return this.add(metal, new DoubleRange(min, max));
        }

        public Builder add(@Nonnull Metal metal, @Nonnull DoubleRange condition) {
            this.builder.put((Object)metal, (Object)condition);
            return this;
        }

        public AlloyRecipe build() {
            return new AlloyRecipe(this.result, this.builder.build());
        }
    }
}

