/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.size;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.DumbStorage;
import net.dries007.tfc.api.capability.ItemStickCapability;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.ItemSizeHandler;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class CapabilityItemSize {
    public static final ResourceLocation KEY = new ResourceLocation("tfc", "item_size");
    public static final Map<IIngredient<ItemStack>, Supplier<ICapabilityProvider>> CUSTOM_ITEMS = new LinkedHashMap<IIngredient<ItemStack>, Supplier<ICapabilityProvider>>();
    @CapabilityInject(value=IItemSize.class)
    public static Capability<IItemSize> ITEM_SIZE_CAPABILITY;

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IItemSize.class, new DumbStorage(), ItemSizeHandler::new);
    }

    public static void init() {
        CUSTOM_ITEMS.put(IIngredient.of(Items.field_151044_h), () -> new ItemSizeHandler(Size.SMALL, Weight.LIGHT, true));
        CUSTOM_ITEMS.put(IIngredient.of(Items.field_151055_y), ItemStickCapability::new);
        CUSTOM_ITEMS.put(IIngredient.of(Items.field_151119_aD), () -> new ItemSizeHandler(Size.SMALL, Weight.VERY_LIGHT, true));
        CUSTOM_ITEMS.put(IIngredient.of(Items.field_151104_aV), () -> new ItemSizeHandler(Size.LARGE, Weight.VERY_HEAVY, false));
        CUSTOM_ITEMS.put(IIngredient.of(Items.field_151143_au), () -> new ItemSizeHandler(Size.LARGE, Weight.VERY_HEAVY, false));
        CUSTOM_ITEMS.put(IIngredient.of((Item)Items.field_179565_cj), () -> new ItemSizeHandler(Size.LARGE, Weight.HEAVY, true));
        CUSTOM_ITEMS.put(IIngredient.of(Items.field_151066_bu), () -> new ItemSizeHandler(Size.LARGE, Weight.LIGHT, true));
        CUSTOM_ITEMS.put(IIngredient.of((Block)Blocks.field_150479_bC), () -> new ItemSizeHandler(Size.SMALL, Weight.VERY_LIGHT, true));
    }

    public static boolean checkItemSize(ItemStack stack, Size size, Weight weight) {
        IItemSize cap = CapabilityItemSize.getIItemSize(stack);
        if (cap != null) {
            return cap.getWeight(stack) == weight && cap.getSize(stack) == size;
        }
        return false;
    }

    @Nullable
    public static IItemSize getIItemSize(ItemStack stack) {
        if (!stack.func_190926_b()) {
            IItemSize size = (IItemSize)stack.getCapability(ITEM_SIZE_CAPABILITY, null);
            if (size != null) {
                return size;
            }
            if (stack.func_77973_b() instanceof IItemSize) {
                return (IItemSize)stack.func_77973_b();
            }
            if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof IItemSize) {
                return (IItemSize)((ItemBlock)stack.func_77973_b()).func_179223_d();
            }
        }
        return null;
    }

    @Nonnull
    public static ICapabilityProvider getCustomSize(ItemStack stack) {
        for (Map.Entry<IIngredient<ItemStack>, Supplier<ICapabilityProvider>> entry : CUSTOM_ITEMS.entrySet()) {
            if (!entry.getKey().testIgnoreCount(stack)) continue;
            return entry.getValue().get();
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemTool || item instanceof ItemSword) {
            return new ItemSizeHandler(Size.LARGE, Weight.MEDIUM, true);
        }
        if (item instanceof ItemArmor) {
            return new ItemSizeHandler(Size.LARGE, Weight.VERY_HEAVY, true);
        }
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof BlockLadder) {
            return new ItemSizeHandler(Size.SMALL, Weight.VERY_LIGHT, true);
        }
        if (item instanceof ItemBlock) {
            return new ItemSizeHandler(Size.SMALL, Weight.LIGHT, true);
        }
        return new ItemSizeHandler(Size.VERY_SMALL, Weight.VERY_LIGHT, true);
    }
}

