/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.heat;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.DumbStorage;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class CapabilityItemHeat {
    public static final ResourceLocation KEY = new ResourceLocation("tfc", "item_heat");
    public static final Map<IIngredient<ItemStack>, Supplier<ICapabilityProvider>> CUSTOM_ITEMS = new HashMap<IIngredient<ItemStack>, Supplier<ICapabilityProvider>>();
    @CapabilityInject(value=IItemHeat.class)
    public static Capability<IItemHeat> ITEM_HEAT_CAPABILITY;

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IItemHeat.class, new DumbStorage(), ItemHeatHandler::new);
    }

    public static void init() {
        CUSTOM_ITEMS.put(IIngredient.of(Items.field_151110_aK), () -> new ItemHeatHandler(null, 1.0f, 480.0f));
        CUSTOM_ITEMS.put(IIngredient.of("blockClay"), () -> new ItemHeatHandler(null, 1.0f, 600.0f));
        CUSTOM_ITEMS.put(IIngredient.of(ItemsTFC.GLASS_SHARD), () -> new ItemHeatHandler(null, 1.0f, 1000.0f));
        CUSTOM_ITEMS.put(IIngredient.of(ItemsTFC.STICK_BUNCH), () -> new ItemHeatHandler(null, 1.0f, 200.0f));
        CUSTOM_ITEMS.put(IIngredient.of("terracotta"), () -> new ItemHeatHandler(null, 1.0f, 1200.0f));
        CUSTOM_ITEMS.put(IIngredient.of(Blocks.field_150411_aY), () -> new ItemHeatHandler(null, Metal.WROUGHT_IRON.getSpecificHeat(), Metal.WROUGHT_IRON.getMeltTemp()));
    }

    public static float adjustTempTowards(float temp, float target, float delta) {
        return CapabilityItemHeat.adjustTempTowards(temp, target, delta, delta);
    }

    public static float adjustTempTowards(float temp, float target, float deltaPositive, float deltaNegative) {
        if (temp < target) {
            return Math.min(temp + deltaPositive, target);
        }
        if (temp > target) {
            return Math.max(temp - deltaNegative, target);
        }
        return target;
    }

    public static float adjustTemp(float temp, float heatCapacity, long ticksSinceUpdate) {
        if (ticksSinceUpdate <= 0L) {
            return temp;
        }
        float newTemp = temp - heatCapacity * (float)ticksSinceUpdate * (float)ConfigTFC.Devices.TEMPERATURE.globalModifier;
        return newTemp < 0.0f ? 0.0f : newTemp;
    }

    public static void addTemp(IItemHeat instance) {
        CapabilityItemHeat.addTemp(instance, 3.0f);
    }

    public static void addTemp(IItemHeat instance, float modifier) {
        float temp = instance.getTemperature() + modifier * instance.getHeatCapacity() * (float)ConfigTFC.Devices.TEMPERATURE.globalModifier;
        instance.setTemperature(temp);
    }

    @Nullable
    public static ICapabilityProvider getCustomHeat(ItemStack stack) {
        Set<IIngredient<ItemStack>> itemItemSet = CUSTOM_ITEMS.keySet();
        for (IIngredient<ItemStack> ingredient : itemItemSet) {
            if (!ingredient.testIgnoreCount(stack)) continue;
            return CUSTOM_ITEMS.get(ingredient).get();
        }
        return null;
    }
}

