/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.forge;

import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IForgeableHeatable
extends IForgeable,
IItemHeat {
    default public float getWorkTemp() {
        return this.getMeltTemp() * 0.6f;
    }

    @Override
    default public boolean isWorkable() {
        return this.getTemperature() > this.getWorkTemp();
    }

    @Override
    default public boolean isWeldable() {
        return this.getTemperature() > this.getWeldTemp();
    }

    default public float getWeldTemp() {
        return this.getMeltTemp() * 0.8f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void addHeatInfo(@Nonnull ItemStack stack, @Nonnull List<String> text) {
        float temperature = this.getTemperature();
        String tooltip = Heat.getTooltip(temperature);
        if (tooltip != null) {
            tooltip = tooltip + TextFormatting.WHITE;
            if (temperature > this.getMeltTemp()) {
                tooltip = tooltip + " - " + I18n.func_135052_a((String)"tfc.tooltip.liquid", (Object[])new Object[0]);
            } else if (temperature > this.getWeldTemp()) {
                tooltip = tooltip + " - " + I18n.func_135052_a((String)"tfc.tooltip.weldable", (Object[])new Object[0]);
            } else if (temperature > this.getWorkTemp()) {
                tooltip = tooltip + " - " + I18n.func_135052_a((String)"tfc.tooltip.workable", (Object[])new Object[0]);
            }
            if ((double)temperature > 0.9 * (double)this.getMeltTemp()) {
                tooltip = tooltip + " (" + I18n.func_135052_a((String)"tfc.tooltip.danger", (Object[])new Object[0]) + ")";
            }
            text.add(tooltip);
        }
    }
}

