/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.forge;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.forge.IForgeableMeasurableMetal;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeableMeasurableMetalHandler
extends ForgeableHeatableHandler
implements IForgeableMeasurableMetal {
    private int metalAmount;
    private Metal metal;

    public ForgeableMeasurableMetalHandler(Metal metal, int metalAmount) {
        this.metalAmount = metalAmount;
        this.metal = metal;
        this.heatCapacity = metal.getSpecificHeat();
        this.meltTemp = metal.getMeltTemp();
    }

    public ForgeableMeasurableMetalHandler(@Nonnull NBTTagCompound nbt) {
        this.metalAmount = 0;
        this.metal = Metal.UNKNOWN;
        this.heatCapacity = Metal.UNKNOWN.getSpecificHeat();
        this.meltTemp = Metal.UNKNOWN.getMeltTemp();
        this.deserializeNBT(nbt);
    }

    @Override
    public int getMetalAmount() {
        return this.metalAmount;
    }

    @Override
    public void setMetalAmount(int metalAmount) {
        this.metalAmount = metalAmount;
    }

    @Override
    public Metal getMetal() {
        return this.metal;
    }

    @Override
    public void setMetal(Metal metal) {
        this.metal = metal;
    }

    @Override
    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("metalAmount", this.metalAmount);
        nbt.func_74778_a("metal", this.metal.getRegistryName().toString());
        return nbt;
    }

    @Override
    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.metalAmount = nbt.func_74762_e("metalAmount");
            ResourceLocation location = new ResourceLocation(nbt.func_74779_i("metal"));
            this.metal = (Metal)TFCRegistries.METALS.getValue(location);
            if (this.metal == null) {
                this.metal = Metal.UNKNOWN;
            }
            this.meltTemp = this.metal.getMeltTemp();
            this.heatCapacity = this.metal.getSpecificHeat();
        }
        super.deserializeNBT(nbt);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHeatInfo(@Nonnull ItemStack stack, @Nonnull List<String> text) {
        String desc = TextFormatting.WHITE + I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{this.metalAmount});
        text.add(desc);
        super.addHeatInfo(stack, text);
    }
}

