/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.forge;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.util.forge.ForgeStep;
import net.dries007.tfc.util.forge.ForgeSteps;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class ForgeableHandler
implements ICapabilitySerializable<NBTTagCompound>,
IForgeable {
    protected final ForgeSteps steps = new ForgeSteps();
    protected int work;
    protected ResourceLocation recipeName;

    public ForgeableHandler(@Nullable NBTTagCompound nbt) {
        this.deserializeNBT(nbt);
    }

    public ForgeableHandler() {
    }

    @Override
    public int getWork() {
        return this.work;
    }

    @Override
    public void setWork(int work) {
        this.work = work;
    }

    @Override
    @Nullable
    public ResourceLocation getRecipeName() {
        return this.recipeName;
    }

    @Override
    public void setRecipe(@Nullable ResourceLocation recipeName) {
        this.recipeName = recipeName;
    }

    @Override
    @Nonnull
    public ForgeSteps getSteps() {
        return this.steps;
    }

    @Override
    public void addStep(ForgeStep step) {
        this.steps.addStep(step);
        this.work += step.getStepAmount();
    }

    @Override
    public void reset() {
        this.steps.reset();
        this.recipeName = null;
        this.work = 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityForgeable.FORGEABLE_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this : null);
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("work", this.work);
        nbt.func_74782_a("steps", (NBTBase)this.steps.serializeNBT());
        if (this.recipeName != null) {
            nbt.func_74778_a("recipe", this.recipeName.toString());
        }
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.work = nbt.func_74762_e("work");
            this.recipeName = nbt.func_74764_b("recipe") ? new ResourceLocation(nbt.func_74779_i("recipe")) : null;
            this.steps.deserializeNBT(nbt.func_74775_l("steps"));
        }
    }
}

