/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.capability.food.IFoodStatsTFC;
import net.dries007.tfc.api.capability.food.NutritionStats;
import net.dries007.tfc.network.PacketFoodStatsReplace;
import net.dries007.tfc.network.PacketFoodStatsUpdate;
import net.dries007.tfc.objects.potioneffects.PotionEffectsTFC;
import net.dries007.tfc.util.DamageSourcesTFC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class FoodStatsTFC
extends FoodStats
implements IFoodStatsTFC {
    public static final float PASSIVE_HEAL_AMOUNT = 0.0039999997f;
    public static final float EXHAUSTION_MULTIPLIER = 0.4f;
    public static final float PASSIVE_EXHAUSTION = 0.0013333333f;
    private final EntityPlayer sourcePlayer;
    private final FoodStats originalStats;
    private final NutritionStats nutritionStats;
    private long lastDrinkTick;
    private float thirst;
    private int healTimer;

    public static void replaceFoodStats(EntityPlayer player) {
        if (!(player.func_71024_bL() instanceof IFoodStatsTFC)) {
            player.field_71100_bB = new FoodStatsTFC(player, player.func_71024_bL());
        }
        if (player instanceof EntityPlayerMP) {
            TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketFoodStatsReplace(), (EntityPlayerMP)player);
        }
    }

    public FoodStatsTFC(EntityPlayer sourcePlayer, FoodStats originalStats) {
        this.sourcePlayer = sourcePlayer;
        this.originalStats = originalStats;
        this.nutritionStats = new NutritionStats(0.5f, 0.0f);
        this.thirst = 100.0f;
    }

    public void func_75122_a(int hungerAmount, float saturationAmount) {
    }

    public void func_151686_a(ItemFood foodItem, ItemStack stack) {
        IFood foodCap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        if (foodCap != null) {
            this.addStats(foodCap);
        } else {
            TerraFirmaCraft.getLog().info("Player ate a weird food: {} / {} that was not a food capability but was an ItemFood...", (Object)foodItem, (Object)stack);
        }
    }

    @Override
    public void addStats(IFood foodCap) {
        FoodData data = foodCap.getData();
        if (!foodCap.isRotten()) {
            this.addThirst(data.getWater());
            this.nutritionStats.addNutrients(data);
            this.originalStats.func_75122_a(data.getHunger(), data.getSaturation() / (2.0f * (float)data.getHunger()));
        } else if (this.sourcePlayer instanceof EntityPlayerMP && (double)Constants.RNG.nextFloat() < 0.6) {
            this.sourcePlayer.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 1800, 1));
            if ((double)Constants.RNG.nextFloat() < 0.15) {
                this.sourcePlayer.func_70690_d(new PotionEffect(PotionEffectsTFC.FOOD_POISON, 1800, 0));
            }
        }
    }

    public void func_75118_a(EntityPlayer player) {
        EnumDifficulty difficulty = player.field_70170_p.func_175659_aa();
        if (difficulty == EnumDifficulty.PEACEFUL && ConfigTFC.General.PLAYER.peacefulDifficultyPassiveRegeneration) {
            if (player.func_70996_bM() && player.field_70173_aa % 20 == 0) {
                player.func_70691_i(1.0f);
            }
            if (player.field_70173_aa % 10 == 0) {
                if (this.func_75121_c()) {
                    this.func_75114_a(this.func_75116_a() + 1);
                }
                if (this.thirst < 100.0f) {
                    this.addThirst(5.0f);
                }
            }
        } else {
            player.func_71020_j(0.0033333332f * (float)ConfigTFC.General.PLAYER.passiveExhaustionMultiplier);
            if (this.originalStats.field_75126_c >= 4.0f) {
                this.addThirst(-((float)ConfigTFC.General.PLAYER.thirstModifier));
            }
            if (difficulty == EnumDifficulty.PEACEFUL && this.originalStats.field_75126_c > 4.0f) {
                this.func_75114_a(Math.max(this.func_75116_a() - 1, 0));
            }
        }
        this.originalStats.func_75118_a(player);
        if (player.func_70996_bM() && (float)this.func_75116_a() >= 4.0f && this.getThirst() > 20.0f) {
            ++this.healTimer;
            float multiplier = 1.0f;
            if ((float)this.func_75116_a() > 16.0f && this.getThirst() > 80.0f) {
                multiplier = 3.0f;
            }
            if (this.healTimer > 10) {
                player.func_70691_i(multiplier * 0.0039999997f * (float)ConfigTFC.General.PLAYER.naturalRegenerationModifier);
                this.healTimer = 0;
            }
        }
        if (!player.field_71075_bZ.field_75098_d && player.field_70173_aa % 100 == 0) {
            if (this.thirst < 10.0f) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 160, 1, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 160, 1, false, false));
                if (this.thirst <= 0.0f) {
                    player.func_70097_a(DamageSourcesTFC.DEHYDRATION, 1.0f);
                }
            } else if (this.thirst < 20.0f) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 160, 0, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 160, 0, false, false));
            }
        }
        if (player instanceof EntityPlayerMP) {
            TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketFoodStatsUpdate(this.nutritionStats.getNutrients(), this.thirst), (EntityPlayerMP)player);
        }
    }

    public void func_75112_a(NBTTagCompound nbt) {
        this.thirst = nbt.func_74760_g("thirst");
        this.lastDrinkTick = nbt.func_74763_f("lastDrinkTick");
        this.nutritionStats.deserializeNBT(nbt.func_74775_l("nutrients"));
        this.originalStats.func_75112_a(nbt);
    }

    public void func_75117_b(NBTTagCompound nbt) {
        nbt.func_74776_a("thirst", this.thirst);
        nbt.func_74776_a("lastDrinkTick", (float)this.lastDrinkTick);
        nbt.func_74782_a("nutrients", (NBTBase)this.nutritionStats.serializeNBT());
        this.originalStats.func_75117_b(nbt);
    }

    public int func_75116_a() {
        return this.originalStats.func_75116_a();
    }

    public boolean func_75121_c() {
        return this.originalStats.func_75121_c();
    }

    public void func_75113_a(float exhaustion) {
        this.originalStats.func_75113_a(0.4f * exhaustion);
    }

    public void func_75114_a(int foodLevelIn) {
        this.originalStats.func_75114_a(foodLevelIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75119_b(float foodSaturationLevelIn) {
        this.originalStats.func_75119_b(foodSaturationLevelIn);
    }

    public void setSaturation(float saturation) {
        this.originalStats.field_75125_b = saturation;
    }

    @SideOnly(value=Side.CLIENT)
    public void onReceivePacket(float[] nutrients, float thirst) {
        this.nutritionStats.onReceivePacket(nutrients);
        this.thirst = thirst;
    }

    @Override
    public float getHealthModifier() {
        return 0.25f + 1.5f * this.nutritionStats.getAverageNutrition();
    }

    @Override
    public float getThirst() {
        return this.thirst;
    }

    @Override
    public void setThirst(float thirst) {
        this.thirst = thirst;
        if (thirst < 0.0f) {
            this.thirst = 0.0f;
        }
        if (thirst > 100.0f) {
            this.thirst = 100.0f;
        }
    }

    @Override
    @Nonnull
    public NutritionStats getNutrition() {
        return this.nutritionStats;
    }

    @Override
    public boolean attemptDrink(float value, boolean simulate) {
        int ticksPassed = (int)(this.sourcePlayer.field_70170_p.func_82737_E() - this.lastDrinkTick);
        if (ticksPassed >= ConfigTFC.General.PLAYER.drinkDelay && this.thirst < 100.0f) {
            if (!simulate) {
                this.resetCooldown();
                this.addThirst(value);
                if (value < 0.0f && Constants.RNG.nextDouble() < ConfigTFC.General.PLAYER.chanceThirstOnSaltyDrink) {
                    this.sourcePlayer.func_70690_d(new PotionEffect(PotionEffectsTFC.THIRST, 600, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetCooldown() {
        this.lastDrinkTick = this.sourcePlayer.field_70170_p.func_82737_E();
    }
}

