/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.util.agriculture.Food;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class FoodHandler
implements IFood,
ICapabilitySerializable<NBTTagCompound> {
    private static final long ROTTEN_DATE = Long.MIN_VALUE;
    private static final long NEVER_DECAY_DATE = Long.MAX_VALUE;
    private static final long UNKNOWN_CREATION_DATE = 0L;
    private static boolean markStacksNonDecaying = true;
    protected final List<FoodTrait> foodTraits = new ArrayList<FoodTrait>(2);
    protected FoodData data;
    protected long creationDate;
    protected boolean isNonDecaying;

    public static void setNonDecaying(boolean markStacksNonDecaying) {
        FoodHandler.markStacksNonDecaying = markStacksNonDecaying;
    }

    public FoodHandler() {
        this(null, new FoodData(4, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
    }

    public FoodHandler(@Nullable NBTTagCompound nbt, @Nonnull Food food) {
        this(nbt, food.getData());
    }

    public FoodHandler(@Nullable NBTTagCompound nbt, FoodData data) {
        this.data = data;
        this.isNonDecaying = markStacksNonDecaying;
        this.deserializeNBT(nbt);
    }

    @Override
    public long getCreationDate() {
        if (this.isNonDecaying) {
            return 0L;
        }
        if (this.calculateRottenDate(this.creationDate) < CalendarTFC.PLAYER_TIME.getTicks()) {
            this.creationDate = Long.MIN_VALUE;
        }
        return this.creationDate;
    }

    @Override
    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public long getRottenDate() {
        if (this.isNonDecaying) {
            return Long.MAX_VALUE;
        }
        if (this.creationDate == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        long rottenDate = this.calculateRottenDate(this.creationDate);
        if (rottenDate < CalendarTFC.PLAYER_TIME.getTicks()) {
            return Long.MIN_VALUE;
        }
        return rottenDate;
    }

    @Override
    @Nonnull
    public FoodData getData() {
        return this.data;
    }

    @Override
    public float getDecayDateModifier() {
        float mod = this.data.getDecayModifier() * (float)ConfigTFC.General.FOOD.decayModifier;
        for (FoodTrait trait : this.foodTraits) {
            mod *= trait.getDecayModifier();
        }
        return mod == 0.0f ? Float.POSITIVE_INFINITY : 1.0f / mod;
    }

    @Override
    public void setNonDecaying() {
        this.isNonDecaying = true;
    }

    @Override
    @Nonnull
    public List<FoodTrait> getTraits() {
        return this.foodTraits;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFood.CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFood.CAPABILITY ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("creationDate", this.getCreationDate());
        if (this.isDynamic()) {
            nbt.func_74782_a("foodData", (NBTBase)this.data.serializeNBT());
        }
        NBTTagList traitList = new NBTTagList();
        for (FoodTrait trait : this.foodTraits) {
            traitList.func_74742_a((NBTBase)new NBTTagString(trait.getName()));
        }
        nbt.func_74782_a("traits", (NBTBase)traitList);
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        this.foodTraits.clear();
        if (nbt != null) {
            if (this.isDynamic()) {
                this.data = new FoodData(nbt.func_74775_l("foodData"));
            }
            NBTTagList traitList = nbt.func_150295_c("traits", 8);
            for (int i = 0; i < traitList.func_74745_c(); ++i) {
                this.foodTraits.add(FoodTrait.getTraits().get(traitList.func_150307_f(i)));
            }
            this.creationDate = nbt.func_74763_f("creationDate");
        }
        if (this.creationDate == 0L) {
            this.creationDate = CapabilityFood.getRoundedCreationDate();
        }
    }

    protected boolean isDynamic() {
        return false;
    }

    private long calculateRottenDate(long creationDateIn) {
        float decayMod = this.getDecayDateModifier();
        if (decayMod == Float.POSITIVE_INFINITY) {
            return Long.MAX_VALUE;
        }
        return creationDateIn + (long)(decayMod * 528000.0f);
    }
}

