/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.DumbStorage;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodHandler;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityFood {
    public static final ResourceLocation KEY = new ResourceLocation("tfc", "food");
    public static final Map<IIngredient<ItemStack>, Supplier<ICapabilityProvider>> CUSTOM_FOODS = new HashMap<IIngredient<ItemStack>, Supplier<ICapabilityProvider>>();
    public static final int DEFAULT_ROT_TICKS = 528000;
    @CapabilityInject(value=IFood.class)
    public static Capability<IFood> CAPABILITY;

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IFood.class, new DumbStorage(), FoodHandler::new);
    }

    public static void init() {
        CUSTOM_FOODS.put(IIngredient.of(Items.field_151078_bh), () -> new FoodHandler(null, FoodData.ROTTEN_FLESH));
        CUSTOM_FOODS.put(IIngredient.of(Items.field_151153_ao), () -> new FoodHandler(null, FoodData.GOLDEN_APPLE));
        CUSTOM_FOODS.put(IIngredient.of(Items.field_151150_bK), () -> new FoodHandler(null, FoodData.GOLDEN_CARROT));
        CUSTOM_FOODS.put(IIngredient.of(Items.field_151110_aK), () -> new FoodHandler(null, FoodData.RAW_EGG));
    }

    public static void applyTrait(IFood instance, FoodTrait trait) {
        if (!instance.getTraits().contains(trait)) {
            if (!instance.isRotten()) {
                instance.setCreationDate(CapabilityFood.calculateNewCreationDate(instance.getCreationDate(), 1.0f / trait.getDecayModifier()));
            }
            instance.getTraits().add(trait);
        }
    }

    public static void applyTrait(ItemStack stack, FoodTrait trait) {
        IFood food = (IFood)stack.getCapability(CAPABILITY, null);
        if (!stack.func_190926_b() && food != null) {
            CapabilityFood.applyTrait(food, trait);
        }
    }

    public static void removeTrait(IFood instance, FoodTrait trait) {
        if (instance.getTraits().contains(trait)) {
            if (!instance.isRotten()) {
                instance.setCreationDate(CapabilityFood.calculateNewCreationDate(instance.getCreationDate(), trait.getDecayModifier()));
            }
            instance.getTraits().remove(trait);
        }
    }

    public static void removeTrait(ItemStack stack, FoodTrait trait) {
        IFood food = (IFood)stack.getCapability(CAPABILITY, null);
        if (!stack.func_190926_b() && food != null) {
            CapabilityFood.removeTrait(food, trait);
        }
    }

    public static ItemStack updateFoodFromPrevious(ItemStack oldStack, ItemStack newStack) {
        IFood oldCap = (IFood)oldStack.getCapability(CAPABILITY, null);
        IFood newCap = (IFood)newStack.getCapability(CAPABILITY, null);
        if (oldCap != null && newCap != null) {
            newCap.getTraits().addAll(oldCap.getTraits());
            float decayDelta = newCap.getDecayDateModifier() / oldCap.getDecayDateModifier();
            newCap.setCreationDate(CapabilityFood.calculateNewCreationDate(oldCap.getCreationDate(), decayDelta));
        }
        return newStack;
    }

    public static ItemStack updateFoodDecayOnCreate(ItemStack stack) {
        IFood cap = (IFood)stack.getCapability(CAPABILITY, null);
        if (cap != null) {
            cap.setCreationDate(CalendarTFC.PLAYER_TIME.getTicks());
        }
        return stack;
    }

    public static void setStackNonDecaying(ItemStack stack) {
        IFood cap = (IFood)stack.getCapability(CAPABILITY, null);
        if (cap != null) {
            cap.setNonDecaying();
        }
    }

    @Nullable
    public static ICapabilityProvider getCustomFood(ItemStack stack) {
        Set<IIngredient<ItemStack>> itemFoodSet = CUSTOM_FOODS.keySet();
        for (IIngredient<ItemStack> ingredient : itemFoodSet) {
            if (!ingredient.testIgnoreCount(stack)) continue;
            return CUSTOM_FOODS.get(ingredient).get();
        }
        return null;
    }

    public static ItemStack mergeItemStacksIgnoreCreationDate(ItemStack stackToMergeInto, ItemStack stackToMerge) {
        if (!stackToMerge.func_190926_b()) {
            if (!stackToMergeInto.func_190926_b()) {
                if (CapabilityFood.areStacksStackableExceptCreationDate(stackToMergeInto, stackToMerge)) {
                    int mergeAmount;
                    IFood mergeIntoFood = (IFood)stackToMergeInto.getCapability(CAPABILITY, null);
                    IFood mergeFood = (IFood)stackToMerge.getCapability(CAPABILITY, null);
                    if (mergeIntoFood != null && mergeFood != null && (mergeAmount = Math.min(stackToMerge.func_190916_E(), stackToMergeInto.func_77976_d() - stackToMergeInto.func_190916_E())) > 0) {
                        mergeIntoFood.setCreationDate(Math.min(mergeIntoFood.getCreationDate(), mergeFood.getCreationDate()));
                        stackToMerge.func_190918_g(mergeAmount);
                        stackToMergeInto.func_190917_f(mergeAmount);
                    }
                }
            } else {
                ItemStack stackToMergeCopy = stackToMerge.func_77946_l();
                stackToMerge.func_190920_e(0);
                return stackToMergeCopy;
            }
        }
        return stackToMergeInto;
    }

    public static boolean areStacksStackableExceptCreationDate(ItemStack stack1, ItemStack stack2) {
        ItemStack stack2Copy;
        IFood food2;
        ItemStack stack1Copy = stack1.func_77946_l();
        IFood food1 = (IFood)stack1Copy.getCapability(CAPABILITY, null);
        if (food1 != null) {
            food1.setCreationDate(0L);
        }
        if ((food2 = (IFood)(stack2Copy = stack2.func_77946_l()).getCapability(CAPABILITY, null)) != null) {
            food2.setCreationDate(0L);
        }
        return ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack1Copy, (ItemStack)stack2Copy);
    }

    public static long getRoundedCreationDate() {
        return CalendarTFC.PLAYER_TIME.getTotalHours() / (long)ConfigTFC.General.FOOD.decayStackTime * 1000L * (long)ConfigTFC.General.FOOD.decayStackTime;
    }

    private static long calculateNewCreationDate(long ci, float p) {
        return (long)((1.0f - p) * (float)CalendarTFC.PLAYER_TIME.getTicks() + p * (float)ci);
    }
}

