/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.egg;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.egg.CapabilityEgg;
import net.dries007.tfc.api.capability.egg.IEgg;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class EggHandler
implements IEgg,
ICapabilitySerializable<NBTTagCompound> {
    private boolean fertilized;
    private long hatchDay;
    private NBTTagCompound entitytag;

    public EggHandler() {
        this(null);
    }

    public EggHandler(@Nullable NBTTagCompound nbt) {
        this.deserializeNBT(nbt);
    }

    public EggHandler(boolean fertilized, long hatchDay, Entity entity) {
        this.fertilized = fertilized;
        this.hatchDay = hatchDay;
        this.entitytag = entity.serializeNBT();
    }

    @Override
    public long getHatchDay() {
        return this.hatchDay;
    }

    @Override
    @Nullable
    public Entity getEntity(World world) {
        return this.entitytag != null ? EntityList.func_75615_a((NBTTagCompound)this.entitytag, (World)world) : null;
    }

    @Override
    public boolean isFertilized() {
        return this.fertilized;
    }

    @Override
    public void setFertilized(@Nonnull Entity entity, long hatchDay) {
        this.fertilized = true;
        this.entitytag = entity.serializeNBT();
        this.hatchDay = hatchDay;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEgg.CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEgg.CAPABILITY ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.entitytag != null) {
            nbt.func_74757_a("fertilized", this.fertilized);
            nbt.func_74772_a("hatchDay", this.hatchDay);
            nbt.func_74782_a("entity", (NBTBase)this.entitytag);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("entity")) {
            this.fertilized = nbt.func_74767_n("fertilized");
            this.hatchDay = nbt.func_74763_f("hatchDay");
            this.entitytag = nbt.func_74775_l("entity");
        } else {
            this.fertilized = false;
            this.entitytag = null;
            this.hatchDay = 0L;
        }
    }
}

