/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.damage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.damage.CapabilityDamageResistance;
import net.dries007.tfc.api.capability.damage.IDamageResistance;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public enum DamageType {
    CRUSHING,
    PIERCING,
    SLASHING,
    GENERIC;


    public static float getModifier(DamageSource source, EntityLivingBase entityUnderAttack) {
        DamageType type = DamageType.get(source);
        float resistance = 0.0f;
        if (type != GENERIC) {
            IDamageResistance resist = (IDamageResistance)entityUnderAttack.getCapability(CapabilityDamageResistance.CAPABILITY, null);
            resistance += type.getModifier(resist);
            if (!source.func_76363_c()) {
                for (ItemStack stack : entityUnderAttack.func_184193_aE()) {
                    IDamageResistance resist2 = stack.func_77973_b() instanceof IDamageResistance ? (IDamageResistance)stack.func_77973_b() : (IDamageResistance)stack.getCapability(CapabilityDamageResistance.CAPABILITY, null);
                    resistance += type.getModifier(resist2);
                }
            }
        }
        return (float)Math.pow(Math.E, -0.01 * (double)resistance);
    }

    @Nonnull
    private static DamageType get(DamageSource source) {
        if (!source.func_76363_c()) {
            for (String damageType : ConfigTFC.General.DAMAGE.slashingSources) {
                if (!damageType.equals(source.field_76373_n)) continue;
                return SLASHING;
            }
            for (String damageType : ConfigTFC.General.DAMAGE.crushingSources) {
                if (!damageType.equals(source.field_76373_n)) continue;
                return CRUSHING;
            }
            for (String damageType : ConfigTFC.General.DAMAGE.piercingSources) {
                if (!damageType.equals(source.field_76373_n)) continue;
                return PIERCING;
            }
            Entity sourceEntity = source.func_76346_g();
            if (sourceEntity != null) {
                DamageType weaponDamageType;
                ItemStack heldItem;
                if (sourceEntity instanceof EntityLivingBase && !(heldItem = ((EntityLivingBase)sourceEntity).func_184614_ca()).func_190926_b() && (weaponDamageType = DamageType.getFromItem(heldItem)) != GENERIC) {
                    return weaponDamageType;
                }
                ResourceLocation entityType = EntityList.func_191301_a((Entity)sourceEntity);
                if (entityType != null) {
                    String entityTypeName = entityType.toString();
                    for (String damageType : ConfigTFC.General.DAMAGE.slashingEntities) {
                        if (!damageType.equals(entityTypeName)) continue;
                        return SLASHING;
                    }
                    for (String damageType : ConfigTFC.General.DAMAGE.crushingEntities) {
                        if (!damageType.equals(entityTypeName)) continue;
                        return CRUSHING;
                    }
                    for (String damageType : ConfigTFC.General.DAMAGE.piercingEntities) {
                        if (!damageType.equals(entityTypeName)) continue;
                        return PIERCING;
                    }
                }
            }
        }
        return GENERIC;
    }

    @Nonnull
    private static DamageType getFromItem(ItemStack stack) {
        if (OreDictionaryHelper.doesStackMatchOre(stack, "damageTypeCrushing")) {
            return CRUSHING;
        }
        if (OreDictionaryHelper.doesStackMatchOre(stack, "damageTypeSlashing")) {
            return SLASHING;
        }
        if (OreDictionaryHelper.doesStackMatchOre(stack, "damageTypePiercing")) {
            return PIERCING;
        }
        return GENERIC;
    }

    private float getModifier(@Nullable IDamageResistance resistSource) {
        if (resistSource != null) {
            switch (this) {
                case CRUSHING: {
                    return resistSource.getCrushingModifier();
                }
                case PIERCING: {
                    return resistSource.getPiercingModifier();
                }
                case SLASHING: {
                    return resistSource.getSlashingModifier();
                }
            }
        }
        return 1.0f;
    }
}

