/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.damage;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.DumbStorage;
import net.dries007.tfc.api.capability.damage.DamageResistance;
import net.dries007.tfc.api.capability.damage.IDamageResistance;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class CapabilityDamageResistance {
    public static final ResourceLocation KEY = new ResourceLocation("tfc", "damage_resistance");
    public static final Map<IIngredient<ItemStack>, Supplier<ICapabilityProvider>> CUSTOM_ARMOR = new HashMap<IIngredient<ItemStack>, Supplier<ICapabilityProvider>>();
    public static final Map<String, Supplier<ICapabilityProvider>> ENTITY_RESISTANCE = new HashMap<String, Supplier<ICapabilityProvider>>();
    @CapabilityInject(value=IDamageResistance.class)
    public static Capability<IDamageResistance> CAPABILITY;

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IDamageResistance.class, new DumbStorage(), () -> new IDamageResistance(){});
    }

    public static void postInit() {
        TerraFirmaCraft.getLog().info("Entity resistance data initialized, loaded a total of {} resistance configurations", (Object)ENTITY_RESISTANCE.size());
    }

    public static void readFile(Set<Map.Entry<String, JsonElement>> jsonElements) {
        for (Map.Entry<String, JsonElement> entry : jsonElements) {
            try {
                String entityName = entry.getKey();
                if ("#loader".equals(entityName)) continue;
                DamageResistance resistance = (DamageResistance)Constants.GSON.fromJson(entry.getValue(), DamageResistance.class);
                ENTITY_RESISTANCE.put(entityName, () -> resistance);
            }
            catch (JsonParseException e) {
                TerraFirmaCraft.getLog().error("An entity resistance is specified incorrectly! Skipping.");
                TerraFirmaCraft.getLog().error("Error: ", (Throwable)e);
            }
        }
    }

    @Nullable
    public static ICapabilityProvider getCustomDamageResistance(ItemStack stack) {
        Set<IIngredient<ItemStack>> itemArmorSet = CUSTOM_ARMOR.keySet();
        for (IIngredient<ItemStack> ingredient : itemArmorSet) {
            if (!ingredient.testIgnoreCount(stack)) continue;
            return CUSTOM_ARMOR.get(ingredient).get();
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="tfc")
    public static final class EventHandler {
        @SubscribeEvent
        public static void attachEntityCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
            String entityTypeName;
            ResourceLocation entityType = EntityList.func_191301_a((Entity)((Entity)event.getObject()));
            if (entityType != null && ENTITY_RESISTANCE.containsKey(entityTypeName = entityType.toString())) {
                event.addCapability(KEY, ENTITY_RESISTANCE.get(entityTypeName).get());
            }
        }
    }
}

