/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStickCapability
extends ItemHeatHandler
implements IItemSize {
    public static final ResourceLocation KEY = new ResourceLocation("tfc", "stick");
    private static final float MELTING_POINT = 40.0f;
    private static final float HEAT_CAPACITY = 1.0f;

    public ItemStickCapability() {
        this(null);
    }

    public ItemStickCapability(@Nullable NBTTagCompound nbt) {
        super(nbt, 1.0f, 40.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHeatInfo(@Nonnull ItemStack stack, @Nonnull List<String> text) {
        float temperature = this.getTemperature();
        if (temperature > this.getMeltTemp() * 0.9f) {
            text.add(I18n.func_135052_a((String)"tfc.enum.heat.torch.lit", (Object[])new Object[0]));
        } else if (temperature > 1.0f) {
            text.add(I18n.func_135052_a((String)"tfc.enum.heat.torch.catching_fire", (Object[])new Object[0]));
        }
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.VERY_LIGHT;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemSize.ITEM_SIZE_CAPABILITY || super.hasCapability(capability, facing);
    }
}

